/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import io.confluent.controlcenter.connect.ConnectService;
import io.confluent.controlcenter.data.ConnectServiceSupplier;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.kafka.connect.runtime.rest.entities.CreateConnectorRequest;

@Path(value="/3.0/management/connect/{clusterId}")
@Produces(value={"application/json"})
public class ConnectResource {
    @GET
    @Path(value="kafka")
    public ConnectService.ConnectKafkaCluster getConnectorClusterInfo(@PathParam(value="clusterId") ConnectServiceSupplier connectService) throws Exception {
        return ((ConnectService)connectService.get()).getConnectKafkaCluster();
    }

    @GET
    @Path(value="connector-plugins")
    public Object connectorPlugins(@PathParam(value="clusterId") ConnectServiceSupplier connectService) throws Exception {
        return ((ConnectService)connectService.get()).getConnectorPlugins();
    }

    @PUT
    @Path(value="connector-plugins/{connectorType}/config/validate")
    public Object putConnectorPlugins(@PathParam(value="clusterId") ConnectServiceSupplier connectService, @PathParam(value="connectorType") String connType, Map<String, String> connectorConfig) throws Exception {
        return ((ConnectService)connectService.get()).validateConnectorPlugin(connType, connectorConfig);
    }

    @GET
    @Path(value="connectors")
    public Object connectors(@PathParam(value="clusterId") ConnectServiceSupplier connectService) throws Exception {
        return ((ConnectService)connectService.get()).getConnectors();
    }

    @POST
    @Path(value="connectors")
    public Object createConnector(@PathParam(value="clusterId") ConnectServiceSupplier connectService, CreateConnectorRequest createRequest) throws Exception {
        return ((ConnectService)connectService.get()).createConnector(createRequest);
    }

    @GET
    @Path(value="connectors/{connector}")
    public Object getConnector(@PathParam(value="clusterId") ConnectServiceSupplier connectService, @PathParam(value="connector") String connector) throws Exception {
        return ((ConnectService)connectService.get()).getConnector(connector);
    }

    @PUT
    @Path(value="connectors/{connector}/pause")
    public Object putConnectorPause(@PathParam(value="clusterId") ConnectServiceSupplier connectService, @PathParam(value="connector") String connector) throws Exception {
        return ((ConnectService)connectService.get()).putConnectorPause(connector);
    }

    @PUT
    @Path(value="connectors/{connector}/resume")
    public Object putConnectorResume(@PathParam(value="clusterId") ConnectServiceSupplier connectService, @PathParam(value="connector") String connector) throws Exception {
        return ((ConnectService)connectService.get()).putConnectorResume(connector);
    }

    @GET
    @Path(value="connectors/{connector}/status")
    public Object getConnectorStatus(@PathParam(value="clusterId") ConnectServiceSupplier connectService, @PathParam(value="connector") String connector) throws Exception {
        return ((ConnectService)connectService.get()).getConnectorStatus(connector);
    }

    @GET
    @Path(value="connectors/{connector}/config")
    public Object getConnectorConfig(@PathParam(value="clusterId") ConnectServiceSupplier connectService, @PathParam(value="connector") String connector) throws Exception {
        return ((ConnectService)connectService.get()).getConnectorConfig(connector);
    }

    @PUT
    @Path(value="connectors/{connector}/config")
    public Object putConnectorConfig(@PathParam(value="clusterId") ConnectServiceSupplier connectService, @PathParam(value="connector") String connector, Map<String, String> connectorConfig) throws Exception {
        return ((ConnectService)connectService.get()).putConnectorConfig(connector, connectorConfig);
    }

    @GET
    @Path(value="connectors/{connector}/tasks")
    public Object getTaskConfigs(@PathParam(value="clusterId") ConnectServiceSupplier connectService, @PathParam(value="connector") String connector) throws Exception {
        return ((ConnectService)connectService.get()).getTaskConfigs(connector);
    }

    @POST
    @Path(value="connectors/{connector}/tasks")
    public Object putTaskConfigs(@PathParam(value="clusterId") ConnectServiceSupplier connectService, @PathParam(value="connector") String connector, List<Map<String, String>> taskConfigs) throws Exception {
        return ((ConnectService)connectService.get()).putTaskConfigs(connector, taskConfigs);
    }

    @GET
    @Path(value="connectors/{connector}/tasks/{task}/status")
    public Object getTaskStatus(@PathParam(value="clusterId") ConnectServiceSupplier connectService, @PathParam(value="connector") String connector, @PathParam(value="task") Integer task) throws Exception {
        return ((ConnectService)connectService.get()).getTaskStatus(connector, task);
    }

    @DELETE
    @Path(value="connectors/{connector}")
    public Object destroyConnector(@PathParam(value="clusterId") ConnectServiceSupplier connectService, @PathParam(value="connector") String connector) throws Exception {
        return ((ConnectService)connectService.get()).destroyConnector(connector);
    }
}

