/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Inject;
import io.confluent.controlcenter.kafka.ConsumerSupplier;
import io.confluent.controlcenter.rest.AbstractConsumerResource;
import io.confluent.controlcenter.rest.JacksonEncoder;
import io.confluent.controlcenter.rest.RestModule;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import javax.annotation.Nullable;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.kafka.clients.consumer.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/2.0/{clusterId}/consumer", encoders={JacksonEncoder.class})
public class ConsumerResource
extends AbstractConsumerResource {
    private static final Logger log = LoggerFactory.getLogger(ConsumerResource.class);
    private final ConsumerSupplier<byte[], byte[], String> consumerSupplier;

    @Inject
    public ConsumerResource(@RestModule.WebSockets ListeningScheduledExecutorService executorService, ConsumerSupplier<byte[], byte[], String> consumerSupplier, @Nullable SchemaRegistryClient schemaRegistryClient) {
        super(executorService, schemaRegistryClient);
        this.consumerSupplier = consumerSupplier;
    }

    @Override
    Consumer<byte[], byte[]> getConsumer(String clusterId, Session session) {
        return this.consumerSupplier.getConsumer(clusterId);
    }
}

