/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.rest.ConsumerResource;
import io.confluent.rest.RestConfig;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlCenterRestModule
implements Module {
    private static final Logger log = LoggerFactory.getLogger(ControlCenterRestModule.class);

    public void configure(Binder binder) {
        binder.bind(ConsumerResource.class);
    }

    @Provides
    @RestEndpoint
    @Singleton
    @Inject
    private String provideRestEndpoint(@DisplayHost String displayHost, RestConfig config) {
        if (!Strings.isNullOrEmpty((String)displayHost)) {
            return displayHost;
        }
        return (String)Iterables.getFirst((Iterable)Iterables.filter((Iterable)config.getList("listeners"), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !Strings.isNullOrEmpty((String)input);
            }
        }), (Object)("http://localhost:" + config.getInt("port")));
    }

    @Provides
    @Singleton
    @Inject
    @RestrictedRoles
    public Collection<String> getRestrictedRoles(ControlCenterConfig config) {
        List restrictedRoles = config.getList("confluent.controlcenter.auth.restricted.roles");
        if (restrictedRoles == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Collection)restrictedRoles);
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface KsqlClusterConfigSupplier {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ConnectClusterConfigSupplier {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface KafkaClusterConfigSupplier {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface RestrictedRoles {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface DisplayHost {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface RestEndpoint {
    }
}

