/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/2.0/feature")
@Produces(value={"application/json"})
public class FeatureFlagResource {
    private final Map<String, Boolean> flags;

    @Inject
    public FeatureFlagResource(ControlCenterConfig config) {
        HashMap flags = Maps.newHashMap();
        flags.put("confluent.controlcenter.ksql.enable", config.getBoolean("confluent.controlcenter.ksql.enable"));
        flags.put("confluent.controlcenter.schema.registry.enable", config.getBoolean("confluent.controlcenter.schema.registry.enable"));
        flags.put("confluent.controlcenter.topic.inspection.enable", config.getBoolean("confluent.controlcenter.topic.inspection.enable"));
        flags.put("confluent.controlcenter.broker.config.edit.enable", config.getBoolean("confluent.controlcenter.broker.config.edit.enable"));
        flags.put("confluent.controlcenter.license.manager.enable", config.getBoolean("confluent.controlcenter.license.manager.enable"));
        this.flags = flags;
    }

    @GET
    @Path(value="/flags")
    public Map<String, Boolean> flags() {
        return this.flags;
    }
}

