/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.confluent.controlcenter.ksql.KsqlClusterMetadata;
import io.confluent.controlcenter.rest.AbstractProxyServlet;
import io.confluent.controlcenter.rest.res.KsqlCluster;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KsqlProxyServlet
extends AbstractProxyServlet {
    private static final String WS_REDIRECT = "ws-redirect";
    private static final String WEBSOCKET_KEYWORD = "websocket";
    private final Random random = new Random();
    private final KsqlClusterMetadata ksqlClusterMetadata;
    private final Map<String, List<String>> ksqlEndpointsLookup;

    @Inject
    public KsqlProxyServlet(KsqlClusterMetadata ksqlClusterMetadata) {
        this.ksqlClusterMetadata = ksqlClusterMetadata;
        this.ksqlEndpointsLookup = Maps.newHashMap();
    }

    public void buildKsqlEndpointLookupTable() {
        for (KsqlCluster ksqlCluster : this.ksqlClusterMetadata.getKsqlClusters()) {
            this.ksqlEndpointsLookup.put(ksqlCluster.getDisplayName(), ksqlCluster.getEndpoints());
        }
    }

    protected void onProxyRewriteFailed(HttpServletRequest clientRequest, HttpServletResponse clientResponse) {
        String location = (String)clientRequest.getAttribute(WS_REDIRECT);
        if (location == null) {
            clientResponse.setStatus(404);
        } else {
            clientResponse.setStatus(302);
            clientResponse.setHeader("Location", location);
        }
    }

    @Override
    protected String rewriteTarget(HttpServletRequest clientRequest) {
        String targetUri = this.extractProxyUri(clientRequest);
        if (targetUri == null) {
            return null;
        }
        if ("Upgrade".equals(clientRequest.getHeader("Connection")) && WEBSOCKET_KEYWORD.equals(clientRequest.getHeader("Upgrade"))) {
            clientRequest.setAttribute(WS_REDIRECT, (Object)targetUri);
            return null;
        }
        return targetUri;
    }

    @Override
    public String lookupEndpoint(String ksqlClusterName) {
        List<String> endpoints = this.ksqlEndpointsLookup.get(ksqlClusterName);
        return endpoints != null && endpoints.size() > 0 ? endpoints.get(this.random.nextInt(endpoints.size())) : null;
    }
}

