/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.license.LicenseInfo;
import io.confluent.controlcenter.license.LicenseManagerNotEnabledException;
import io.confluent.controlcenter.rest.req.UpdateLicenseRequest;
import io.confluent.controlcenter.rest.res.UpdateLicenseResponse;
import io.confluent.license.InvalidLicenseException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/3.0/license")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LicenseResource {
    private final LicenseInfo licenseInfo;
    private final ControlCenterConfig controlCenterConfig;

    @Inject
    public LicenseResource(LicenseInfo licenseInfo, ControlCenterConfig controlCenterConfig) {
        this.licenseInfo = licenseInfo;
        this.controlCenterConfig = controlCenterConfig;
    }

    @GET
    public LicenseInfo licenseInfo() {
        return this.licenseInfo;
    }

    @GET
    @Path(value="/expiration")
    public long expiration() {
        return this.licenseInfo.getExpiration();
    }

    @GET
    @Path(value="/audience")
    public String audience() {
        return this.licenseInfo.getAudience();
    }

    @GET
    @Path(value="/string")
    public String string() throws LicenseManagerNotEnabledException {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.license.manager.enable")) {
            throw new LicenseManagerNotEnabledException("License Manager is not enabled. ");
        }
        return this.licenseInfo.getString();
    }

    @POST
    @Path(value="/string:update")
    public UpdateLicenseResponse updateLicense(UpdateLicenseRequest updateLicenseRequest) throws InvalidLicenseException, LicenseManagerNotEnabledException {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.license.manager.enable")) {
            throw new LicenseManagerNotEnabledException("License Manager is not enabled. You cannot update license through REST request directly. You can apply your new license by updating properties file and restarting control center.");
        }
        boolean updateSucceed = this.licenseInfo.setLicenseString(updateLicenseRequest.getLicenseString());
        return new UpdateLicenseResponse(updateSucceed, new UpdateLicenseResponse.CurrentLicense().setInfo(this.licenseInfo).build(), "");
    }
}

