/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyRolesFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyRolesFilter.class);
    public static final Set<String> READ_METHODS = ImmutableSet.of((Object)"GET", (Object)"HEAD", (Object)"OPTIONS");
    private final Collection<String> roles;

    ReadOnlyRolesFilter(Collection<String> roles) {
        this.roles = roles;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!READ_METHODS.contains(requestContext.getMethod())) {
            SecurityContext securityContext = requestContext.getSecurityContext();
            for (String role : this.roles) {
                if (!securityContext.isUserInRole(role)) continue;
                log.trace("user={} in role={}", (Object)securityContext.getUserPrincipal(), (Object)role);
                throw new NotAuthorizedException((Object)(securityContext.getUserPrincipal() + " only has read access"), new Object[0]);
            }
        }
    }
}

