/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Preconditions;
import io.confluent.controlcenter.rest.ExpiringSessionAuthentication;
import io.confluent.monitoring.common.Clock;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionBasicAuthenticator
extends BasicAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SessionBasicAuthenticator.class);
    private final Clock clock;
    private final long authSessionExpiration;

    public SessionBasicAuthenticator(Clock clock, long authSessionExpiration) {
        Preconditions.checkArgument((authSessionExpiration > 0L ? 1 : 0) != 0);
        this.clock = clock;
        this.authSessionExpiration = authSessionExpiration;
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession session = request.getSession(false);
        try {
            ExpiringSessionAuthentication authentication;
            ExpiringSessionAuthentication expiringSessionAuthentication = authentication = session == null ? null : (ExpiringSessionAuthentication)((Object)session.getAttribute("org.eclipse.jetty.security.UserIdentity"));
            if (authentication != null) {
                if (authentication.isExpired(this.clock.currentTimeMillis())) {
                    LOG.debug("session auth cache expired, forcing re-authentication");
                    session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
                } else {
                    LOG.trace("using session cache for authentication and authorization");
                    return authentication;
                }
            }
            return super.validateRequest(req, res, mandatory);
        }
        catch (ServerAuthException e) {
            if (session != null) {
                session.invalidate();
            }
            throw e;
        }
    }

    public UserIdentity login(String username, Object password, ServletRequest request) {
        UserIdentity user = super.login(username, password, request);
        if (user != null) {
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            long expirationTime = this.clock.currentTimeMillis() + this.authSessionExpiration;
            ExpiringSessionAuthentication cached = new ExpiringSessionAuthentication(this.getAuthMethod(), user, password, expirationTime);
            session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)cached);
        }
        return user;
    }
}

