/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.confluent.controlcenter.streams.aggregation.MetricValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;

public class TimeseriesUtils {
    static Map<String, Object> flattenLast(List<Map<String, Object>> ts) {
        HashMap res = Maps.newHashMap((Map)((Map)Iterables.getLast(ts, (Object)ImmutableMap.of())));
        res.remove("timestamp");
        return res;
    }

    public static <V> List<Map<String, Object>> mergeTimeseriesAsMap(String k1, List<? extends KeyValue<Long, ? extends V>> ts1) {
        return TimeseriesUtils.mergeTimeseriesAsMap(new String[]{k1}, new List[]{ts1});
    }

    public static <V> List<Map<String, Object>> mergeTimeseriesAsMap(String k1, List<? extends KeyValue<Long, ? extends V>> ts1, String k2, List<? extends KeyValue<Long, ? extends V>> ts2) {
        return TimeseriesUtils.mergeTimeseriesAsMap(new String[]{k1, k2}, new List[]{ts1, ts2});
    }

    public static <V> List<Map<String, Object>> mergeTimeseriesAsMap(String k1, List<? extends KeyValue<Long, ? extends V>> ts1, String k2, List<? extends KeyValue<Long, ? extends V>> ts2, String k3, List<? extends KeyValue<Long, ? extends V>> ts3) {
        return TimeseriesUtils.mergeTimeseriesAsMap(new String[]{k1, k2, k3}, new List[]{ts1, ts2, ts3});
    }

    public static <V> List<Map<String, Object>> mergeTimeseriesAsMap(String k1, List<? extends KeyValue<Long, ? extends V>> ts1, String k2, List<? extends KeyValue<Long, ? extends V>> ts2, String k3, List<? extends KeyValue<Long, ? extends V>> ts3, String k4, List<? extends KeyValue<Long, ? extends V>> ts4) {
        return TimeseriesUtils.mergeTimeseriesAsMap(new String[]{k1, k2, k3, k4}, new List[]{ts1, ts2, ts3, ts4});
    }

    public static <V> List<Map<String, Object>> mergeTimeseriesAsMap(String k1, List<? extends KeyValue<Long, ? extends V>> ts1, String k2, List<? extends KeyValue<Long, ? extends V>> ts2, String k3, List<? extends KeyValue<Long, ? extends V>> ts3, String k4, List<? extends KeyValue<Long, ? extends V>> ts4, String k5, List<? extends KeyValue<Long, ? extends V>> ts5) {
        return TimeseriesUtils.mergeTimeseries(new String[]{k1, k2, k3, k4, k5}, new List[]{ts1, ts2, ts3, ts4, ts5});
    }

    public static <V> List<Map<String, Object>> mergeTimeseriesAsMap(String k1, List<? extends KeyValue<Long, ? extends V>> ts1, String k2, List<? extends KeyValue<Long, ? extends V>> ts2, String k3, List<? extends KeyValue<Long, ? extends V>> ts3, String k4, List<? extends KeyValue<Long, ? extends V>> ts4, String k5, List<? extends KeyValue<Long, ? extends V>> ts5, String k6, List<? extends KeyValue<Long, ? extends V>> ts6) {
        return TimeseriesUtils.mergeTimeseriesAsMap(new String[]{k1, k2, k3, k4, k5, k6}, new List[]{ts1, ts2, ts3, ts4, ts5, ts6});
    }

    public static <V> List<Map<String, Object>> mergeTimeseriesAsMap(String[] keys, List<? extends KeyValue<Long, ? extends V>>[] series) {
        return TimeseriesUtils.mergeTimeseriesAsMap(Arrays.asList(keys), Arrays.asList(series));
    }

    public static <V> List<Map<String, Object>> mergeTimeseriesAsMap(Collection<String> keys, Collection<? extends List<? extends KeyValue<Long, ? extends V>>> series) {
        return Lists.transform(TimeseriesUtils.mergeTimeseries(keys, series), (Function)new Function<KeyValue<Long, Map<String, V>>, Map<String, Object>>(){

            public Map<String, Object> apply(KeyValue<Long, Map<String, V>> input) {
                LinkedHashMap res = Maps.newLinkedHashMap((Map)((Map)input.value));
                res.put("timestamp", input.key);
                return res;
            }
        });
    }

    public static <K, V> List<KeyValue<Long, Map<K, V>>> mergeTimeseries(K[] keys, List<? extends KeyValue<Long, ? extends V>>[] series) {
        return TimeseriesUtils.mergeTimeseries(Arrays.asList(keys), Arrays.asList(series));
    }

    public static <K, V> List<KeyValue<Long, Map<K, V>>> mergeTimeseries(final Collection<K> keys, Collection<? extends List<? extends KeyValue<Long, ? extends V>>> series) {
        Preconditions.checkArgument((keys.size() == series.size() ? 1 : 0) != 0, (Object)"number of names must match number of series");
        return TimeseriesUtils.mergeTimeseries(series, new Function<List<V>, Map<K, V>>(){

            public Map<K, V> apply(List<V> input) {
                LinkedHashMap res = Maps.newLinkedHashMap();
                Iterator it = input.iterator();
                for (Object key : keys) {
                    res.put(key, it.next());
                }
                return res;
            }
        });
    }

    public static <V, R> List<KeyValue<Long, R>> mergeTimeseries(Collection<? extends List<? extends KeyValue<Long, ? extends V>>> series, final Function<List<V>, R> f) {
        final ArrayList<LinkedHashMap> maps = new ArrayList<LinkedHashMap>(series.size());
        for (List<KeyValue<Long, V>> ts : series) {
            LinkedHashMap m = Maps.newLinkedHashMap();
            for (KeyValue<Long, V> keyValue : ts) {
                m.put(keyValue.key, keyValue.value);
            }
            maps.add(m);
        }
        ImmutableSet timestamps = FluentIterable.from(maps).transformAndConcat(new Function<Map<Long, V>, Iterable<Long>>(){

            public Iterable<Long> apply(Map<Long, V> input) {
                return input.keySet();
            }
        }).toSet();
        return FluentIterable.from((Iterable)timestamps).transform(new Function<Long, KeyValue<Long, R>>(){

            public KeyValue<Long, R> apply(final Long timestamp) {
                List values = Lists.transform((List)maps, (Function)new Function<Map<Long, V>, V>(){

                    public V apply(Map<Long, V> input) {
                        return input.get(timestamp);
                    }
                });
                Object res = f.apply((Object)values);
                return KeyValue.pair((Object)timestamp, (Object)res);
            }
        }).toList();
    }

    public static <T> Iterator<T> nullToEmpty(Iterator<T> iterator) {
        return iterator != null ? iterator : Collections.emptyIterator();
    }

    public static <V, R> List<KeyValue<Long, R>> map(List<KeyValue<Long, V>> ts, final Function<V, R> f) {
        return Lists.transform(ts, (Function)new Function<KeyValue<Long, V>, KeyValue<Long, R>>(){

            public KeyValue<Long, R> apply(KeyValue<Long, V> input) {
                return KeyValue.pair((Object)input.key, (Object)f.apply(input.value));
            }
        });
    }

    public static MetricValues singleMetricValue(final long value) {
        return new MetricValues(){

            @Override
            public long max() {
                return value;
            }

            @Override
            public long min() {
                return value;
            }

            @Override
            public long sum() {
                return value;
            }

            @Override
            public long count() {
                return 1L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"MetricValues").add("max", this.max()).add("min", this.min()).add("sum", this.sum()).add("count", this.count()).toString();
            }
        };
    }

    public static Long min(List<KeyValue<Long, MetricValues>> ts) {
        Long min = null;
        for (KeyValue<Long, MetricValues> v : ts) {
            if (v.value == null || min != null && ((MetricValues)v.value).min() >= min) continue;
            min = ((MetricValues)v.value).min();
        }
        return min;
    }

    public static Long max(List<KeyValue<Long, MetricValues>> ts) {
        Long max = null;
        for (KeyValue<Long, MetricValues> v : ts) {
            if (v.value == null || max != null && ((MetricValues)v.value).max() <= max) continue;
            max = ((MetricValues)v.value).max();
        }
        return max;
    }

    public static List<KeyValue<Long, Long>> meanTimesConstant(List<KeyValue<Long, MetricValues>> metric, List<KeyValue<Long, Long>> constant) {
        return TimeseriesUtils.mergeTimeseries(ImmutableList.of(constant, metric), new Function<List<Object>, Long>(){

            public Long apply(List<Object> input) {
                Long constant1 = (Long)input.get(0);
                MetricValues metric1 = (MetricValues)input.get(1);
                return metric1 != null && constant1 != null ? Long.valueOf(metric1.sum() * constant1 / metric1.count()) : null;
            }
        });
    }
}

