/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.client;

import io.confluent.controlcenter.rest.client.TargetPool;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.client.WebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTarget<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseTarget.class);
    private final TargetPool targetPool;
    private WebTarget baseTarget;
    private T baseValue;

    public BaseTarget(TargetPool targetPool) {
        this.targetPool = targetPool;
    }

    public WebTarget getBaseTarget() {
        return this.baseTarget;
    }

    public BaseTarget invoke() throws InterruptedException, TimeoutException, ExecutionException {
        this.baseTarget = null;
        this.baseValue = null;
        int retries = 3;
        while (this.baseValue == null && retries-- > 0) {
            try {
                WebTarget newbaseTarget = this.baseTarget;
                int baseRetries = 3;
                while (newbaseTarget == this.baseTarget && baseRetries-- > 0) {
                    newbaseTarget = this.targetPool.get();
                }
                this.baseTarget = newbaseTarget;
                this.baseValue = this.getBaseValue(this.baseTarget);
            }
            catch (ExecutionException ee) {
                log.warn("unable to connect to basetarget={} ", (Object)this.baseTarget.getUri(), (Object)ee.getMessage());
                if (retries <= 0) {
                    throw ee;
                }
                Thread.sleep(50L);
            }
        }
        return this;
    }

    public T get() {
        return this.baseValue;
    }

    public abstract T getBaseValue(WebTarget var1) throws InterruptedException, ExecutionException, TimeoutException;
}

