/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.client;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import io.confluent.controlcenter.connect.ConnectService;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetPool
implements Supplier<WebTarget> {
    private static final Logger log = LoggerFactory.getLogger(ConnectService.class);
    private final List<WebTarget> webTargets;
    Random random = new Random();

    public TargetPool(Collection<String> targets) {
        final Client client = ClientBuilder.newClient();
        this.webTargets = ImmutableList.copyOf((Collection)Collections2.transform(targets, (Function)new Function<String, WebTarget>(){

            public WebTarget apply(String url) {
                return client.target(url.startsWith("http://") ? url : "http://" + url);
            }
        }));
    }

    public WebTarget get() {
        if (this.webTargets.isEmpty()) {
            return null;
        }
        return this.webTargets.get(this.random.nextInt(this.webTargets.size()));
    }
}

