/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import io.confluent.controlcenter.rest.jackson.JsonStandard;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonStandard
public class ConsumerGroupOffsets {
    public final Map<String, TopicOffsets> consumerGroupOffsets = new HashMap<String, TopicOffsets>();
    private static final Logger log = LoggerFactory.getLogger(ConsumerGroupOffsets.class);
    private final String consumerGroupId;
    private long sumCurrentOffset = 0L;
    private long sumEndOffset = 0L;
    private long totalLag = 0L;
    private Set<String> consumers = new HashSet<String>();

    public ConsumerGroupOffsets(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public long getTotalLag() {
        return this.totalLag;
    }

    public long getSumCurrentOffset() {
        return this.sumCurrentOffset;
    }

    public long getSumEndOffset() {
        return this.sumEndOffset;
    }

    public int getNumTopics() {
        return this.consumerGroupOffsets.size();
    }

    public int getNumConsumers() {
        return this.consumers.size();
    }

    public void addOffset(String topic, String consumerId, int partition, long currentOffset, long endOffset) {
        TopicOffsets topicOffsets = this.consumerGroupOffsets.get(topic);
        if (topicOffsets == null) {
            topicOffsets = new TopicOffsets(topic);
            this.consumerGroupOffsets.put(topic, topicOffsets);
        }
        Offset offset = new Offset(topic, consumerId, partition, currentOffset, endOffset);
        topicOffsets.addOffset(offset);
        this.totalLag += offset.getLag();
        this.sumCurrentOffset += offset.currentOffset;
        this.sumEndOffset += offset.endOffset;
        if (consumerId != null && !consumerId.isEmpty()) {
            this.consumers.add(consumerId);
        }
    }

    public static class Offset {
        public final String topic;
        public final String consumerId;
        public final int partition;
        public final long currentOffset;
        public final long endOffset;

        public Offset(String topic, String consumerId, int partition, long currentOffset, long endOffset) {
            this.topic = topic;
            this.consumerId = consumerId;
            this.partition = partition;
            this.currentOffset = currentOffset;
            this.endOffset = endOffset;
        }

        public long getLag() {
            return this.endOffset - this.currentOffset;
        }

        public String getKey() {
            return this.topic + "-" + this.consumerId + "-" + this.partition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Offset that = (Offset)o;
            return Objects.equals(this.topic, that.topic) && Objects.equals(this.consumerId, that.consumerId) && Objects.equals(this.partition, that.partition);
        }

        public int hashCode() {
            return Objects.hash(this.topic, this.consumerId, this.partition);
        }
    }

    public static class TopicOffsets {
        public final String topic;
        private long maxLag;
        private Set<Offset> topicOffsets = new HashSet<Offset>();

        public TopicOffsets(String topic) {
            this.topic = topic;
        }

        public void addOffset(Offset offset) {
            if (this.topicOffsets.contains(offset)) {
                log.warn("trying to add duplicated topic offsets data={}", (Object)offset);
                return;
            }
            this.topicOffsets.add(offset);
            if (this.maxLag < offset.getLag()) {
                this.maxLag = offset.getLag();
            }
        }

        public Set<Offset> getTopicOffsets() {
            return this.topicOffsets;
        }

        public long getMaxLag() {
            return this.maxLag;
        }
    }
}

