/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Function;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OmgDeserializer {
    private static final Logger log = LoggerFactory.getLogger(OmgDeserializer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final StringDeserializer STRING_DESERIALIZER = new StringDeserializer();
    private final KafkaAvroDeserializer avroDeserializer;
    private final FormatMemoizingDeserializer keyDeserializer = new FormatMemoizingDeserializer();
    private final FormatMemoizingDeserializer valueDeserializer = new FormatMemoizingDeserializer();

    public OmgDeserializer(SchemaRegistryClient schemaRegistryClient) {
        this.avroDeserializer = new KafkaAvroDeserializer(schemaRegistryClient);
    }

    public Object deserializeKey(ConsumerRecord<byte[], byte[]> record) {
        return this.keyDeserializer.get(this.avroDeserializer, ConsumerRecord::key, record).apply(record);
    }

    public Object deserializeValue(ConsumerRecord<byte[], byte[]> record) {
        return this.valueDeserializer.get(this.avroDeserializer, ConsumerRecord::value, record).apply(record);
    }

    private static Function<ConsumerRecord<byte[], byte[]>, Object> detect(KafkaAvroDeserializer avroDeserializer, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        byte[] bytes = selector.apply(record);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            OmgDeserializer.fromAvro(avroDeserializer, selector, record);
            return r -> OmgDeserializer.fromAvro(avroDeserializer, selector, (ConsumerRecord<byte[], byte[]>)r);
        }
        catch (Exception e) {
            log.trace("unable to deserialize avro", (Throwable)e);
            try {
                OmgDeserializer.fromJson(bytes);
                return ((Function<byte[], Object>)OmgDeserializer::fromJson).compose(selector);
            }
            catch (Exception e2) {
                log.trace("unable to deserialize json", (Throwable)e2);
                try {
                    OmgDeserializer.fromString(bytes);
                    return ((Function<byte[], Object>)OmgDeserializer::fromString).compose(selector);
                }
                catch (Exception e3) {
                    log.trace("unable to deserialize string", (Throwable)e3);
                    return ((Function<byte[], Object>)OmgDeserializer::objectCast).compose(selector);
                }
            }
        }
    }

    private static <T> Object objectCast(T value) {
        return value;
    }

    private static Object fromJson(byte[] bytes) {
        try {
            return OBJECT_MAPPER.readValue(bytes, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private static String fromString(byte[] bytes) {
        return STRING_DESERIALIZER.deserialize(null, bytes);
    }

    private static Object fromAvro(KafkaAvroDeserializer avroDeserializer, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            GenericRecord avroRecord = (GenericRecord)avroDeserializer.deserialize(record.topic(), selector.apply(record));
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(avroRecord.getSchema(), (OutputStream)out);
            GenericDatumWriter writer = new GenericDatumWriter(avroRecord.getSchema());
            writer.write((Object)avroRecord, (Encoder)encoder);
            encoder.flush();
            return OmgDeserializer.fromJson(out.toByteArray());
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private static class FormatMemoizingDeserializer {
        Function<ConsumerRecord<byte[], byte[]>, Object> memoized;

        private FormatMemoizingDeserializer() {
        }

        public Function<ConsumerRecord<byte[], byte[]>, Object> get(KafkaAvroDeserializer avroDeserializer, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
            if (this.memoized == null) {
                this.memoized = OmgDeserializer.detect(avroDeserializer, selector, (ConsumerRecord<byte[], byte[]>)record);
            }
            return this.memoized != null ? this.memoized : ((Function<byte[], Object>)x$0 -> OmgDeserializer.objectCast(x$0)).compose(selector);
        }
    }
}

