/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.confluent.controlcenter.license.LicenseInfo;
import io.confluent.controlcenter.rest.jackson.JsonStandard;
import java.util.Objects;

@JsonStandard
public class UpdateLicenseResponse {
    @JsonProperty
    private final boolean updateSucceed;
    @JsonProperty
    private final CurrentLicense currentLicense;
    @JsonProperty
    private final String error;

    public UpdateLicenseResponse(boolean updateSucceed, CurrentLicense currentLicense, String error) {
        Preconditions.checkNotNull((Object)updateSucceed);
        Preconditions.checkNotNull((Object)currentLicense);
        this.updateSucceed = updateSucceed;
        this.currentLicense = currentLicense;
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateLicenseResponse that = (UpdateLicenseResponse)o;
        return Objects.equals(this.updateSucceed, that.updateSucceed) && Objects.equals(this.currentLicense, that.currentLicense) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.updateSucceed, this.currentLicense, this.error);
    }

    @JsonStandard
    public static class CurrentLicense {
        @JsonProperty
        private String audience;
        @JsonProperty
        private long expiration;
        @JsonProperty
        private String string;

        public CurrentLicense setInfo(LicenseInfo licenseInfo) {
            this.audience = licenseInfo.getAudience();
            this.expiration = licenseInfo.getExpiration();
            this.string = licenseInfo.getString();
            return this;
        }

        public CurrentLicense build() {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CurrentLicense that = (CurrentLicense)o;
            return Objects.equals(this.audience, that.audience) && Objects.equals(this.expiration, that.expiration) && Objects.equals(this.string, that.string);
        }

        public int hashCode() {
            return Objects.hash(this.audience, this.expiration, this.string);
        }
    }
}

