/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.confluent.controlcenter.serialization.WindowStoreUtils;
import io.confluent.serializers.SerdeWithJson;
import io.confluent.serializers.UberSerde;
import java.nio.ByteBuffer;
import org.apache.kafka.streams.state.StateSerdes;

public class WindowStoreSerde<T>
implements SerdeWithJson<WindowedKey<T>> {
    private final Gson gson = new Gson();
    private final UberSerde<T> keySerde;
    private final StateSerdes<T, T> serdes;

    public WindowStoreSerde(UberSerde<T> keySerde) {
        this.keySerde = keySerde;
        this.serdes = new StateSerdes("dummy", keySerde, keySerde);
    }

    public byte[] serialize(WindowedKey<T> windowedKey) {
        return WindowStoreUtils.toBinaryKey(windowedKey.key, windowedKey.timestamp, windowedKey.seqNum, this.serdes).get();
    }

    public WindowedKey<T> deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        T key = WindowStoreUtils.keyFromBinaryKey(bytes, this.serdes);
        long timestamp = WindowStoreUtils.timestampFromBinaryKey(bytes);
        int seqNum = this.sequenceNumberFromBinaryKey(bytes);
        return new WindowedKey<T>(key, timestamp, seqNum);
    }

    private int sequenceNumberFromBinaryKey(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt(bytes.length - 8);
    }

    public byte[] fromJson(String json) {
        WindowedKey windowedKey = (WindowedKey)this.gson.fromJson(json, WindowedKey.class);
        String objJson = this.gson.toJson(windowedKey.key);
        Object key = this.keySerde.deserialize(this.keySerde.fromJson(objJson));
        return WindowStoreUtils.toBinaryKey(key, windowedKey.timestamp, windowedKey.seqNum, this.serdes).get();
    }

    public String toJson(WindowedKey<T> windowedKey) {
        Gson gson = new Gson();
        JsonObject doc = new JsonObject();
        doc.add("key", (JsonElement)gson.fromJson(this.keySerde.toJson(windowedKey.key), JsonElement.class));
        doc.add("timestamp", (JsonElement)new JsonPrimitive((Number)windowedKey.timestamp));
        doc.add("seq_num", (JsonElement)new JsonPrimitive((Number)windowedKey.seqNum));
        return gson.toJson((JsonElement)doc);
    }

    public static class WindowedKey<T> {
        public final T key;
        public final long timestamp;
        public final int seqNum;

        public WindowedKey(T key, long timestamp, int seqNum) {
            this.key = key;
            this.timestamp = timestamp;
            this.seqNum = seqNum;
        }
    }
}

