/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.aggregation.GroupBy;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Printed;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TopicNameExtractor;

public class C3Stream<K, V>
implements KStream<K, V> {
    final KStream<K, V> delegate;
    final StreamsBuilder builder;

    public C3Stream(KStream<K, V> delegate, StreamsBuilder builder) {
        this.delegate = delegate;
        this.builder = builder;
    }

    public <K2, V2> C3Stream<K2, V2> wrap(KStream<K2, V2> toWrap) {
        return new C3Stream<K2, V2>(toWrap, this.builder);
    }

    public C3Stream<K, V> filter(Predicate<? super K, ? super V> predicate) {
        return this.wrap(this.delegate.filter(predicate));
    }

    public C3Stream<K, V> filterNot(Predicate<? super K, ? super V> predicate) {
        return this.wrap(this.delegate.filterNot(predicate));
    }

    public <K1> C3Stream<K1, V> selectKey(KeyValueMapper<? super K, ? super V, ? extends K1> mapper) {
        return this.wrap(this.delegate.selectKey(mapper));
    }

    public <K1, V1> C3Stream<K1, V1> map(KeyValueMapper<? super K, ? super V, ? extends KeyValue<? extends K1, ? extends V1>> mapper) {
        return this.wrap(this.delegate.map(mapper));
    }

    public <V1> C3Stream<K, V1> mapValues(ValueMapper<? super V, ? extends V1> mapper) {
        return this.wrap(this.delegate.mapValues(mapper));
    }

    public <V1> C3Stream<K, V1> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends V1> mapper) {
        return this.wrap(this.delegate.mapValues(mapper));
    }

    public void print(Printed<K, V> printed) {
        this.delegate.print(printed);
    }

    public C3Stream<K, V> merge(KStream<K, V> stream) {
        return this.wrap(this.delegate.merge(stream));
    }

    public <K1, V1> C3Stream<K1, V1> flatMap(KeyValueMapper<? super K, ? super V, ? extends Iterable<? extends KeyValue<? extends K1, ? extends V1>>> mapper) {
        return this.wrap(this.delegate.flatMap(mapper));
    }

    public <V1> C3Stream<K, V1> flatMapValues(ValueMapper<? super V, ? extends Iterable<? extends V1>> processor) {
        return this.wrap(this.delegate.flatMapValues(processor));
    }

    public <V1> C3Stream<K, V1> flatMapValues(ValueMapperWithKey<? super K, ? super V, ? extends Iterable<? extends V1>> processor) {
        return this.wrap(this.delegate.flatMapValues(processor));
    }

    public C3Stream<K, V>[] branch(Predicate<? super K, ? super V> ... predicates) {
        KStream[] streams = this.delegate.branch(predicates);
        C3Stream[] branches = new C3Stream[streams.length];
        for (int i = 0; i < streams.length; ++i) {
            branches[i] = this.wrap(streams[i]);
        }
        return branches;
    }

    public void foreach(ForeachAction<? super K, ? super V> action) {
        this.delegate.foreach(action);
    }

    public C3Stream<K, V> through(String topic) {
        return this.wrap(this.delegate.through(topic));
    }

    public <K1, T1> C3Stream<K, V> through(TopicStoreMaster.Topic<K, V, K1, T1> topic) {
        this.to(topic);
        return this.wrap(this.builder.stream(topic.name, Consumed.with(topic.keySerde, topic.valueSerde)));
    }

    public <K2, T2> C3Stream<K, V> through(StreamPartitioner<? super K, ? super V> partitioner, TopicStoreMaster.Topic<K, V, K2, T2> topic) {
        this.to(topic.name, Produced.with(topic.keySerde, topic.valueSerde, partitioner));
        return this.wrap(this.builder.stream(topic.name, Consumed.with(topic.keySerde, topic.valueSerde)));
    }

    public KStream<K, V> through(String topic, Produced<K, V> produced) {
        return this.wrap(this.delegate.through(topic, produced));
    }

    public <K1, T1> void to(TopicStoreMaster.Topic<K, V, K1, T1> topic) {
        this.delegate.to(topic.name, Produced.with(topic.keySerde, topic.valueSerde));
    }

    public void to(String topic) {
        this.delegate.to(topic);
    }

    public void to(String topic, Produced<K, V> produced) {
        this.delegate.to(topic, produced);
    }

    public void to(TopicNameExtractor<K, V> topicExtractor) {
        this.delegate.to(topicExtractor);
    }

    public void to(TopicNameExtractor<K, V> topicExtractor, Produced<K, V> produced) {
        this.delegate.to(topicExtractor, produced);
    }

    public <K1, V1> C3Stream<K1, V1> transform(TransformerSupplier<? super K, ? super V, KeyValue<K1, V1>> transformerSupplier, String ... stateStoreNames) {
        return this.wrap(this.delegate.transform(transformerSupplier, stateStoreNames));
    }

    public <K1, V1> C3Stream<K1, V1> flatTransform(TransformerSupplier<? super K, ? super V, Iterable<KeyValue<K1, V1>>> transformerSupplier, String ... stateStoreNames) {
        return this.wrap(this.delegate.flatTransform(transformerSupplier, stateStoreNames));
    }

    public <R> C3Stream<K, R> transformValues(ValueTransformerSupplier<? super V, ? extends R> valueTransformerSupplier, String ... stateStoreNames) {
        return this.wrap(this.delegate.transformValues(valueTransformerSupplier, stateStoreNames));
    }

    public <R> C3Stream<K, R> transformValues(ValueTransformerWithKeySupplier<? super K, ? super V, ? extends R> valueTransformerSupplier, String ... stateStoreNames) {
        return this.wrap(this.delegate.transformValues(valueTransformerSupplier, stateStoreNames));
    }

    public void process(ProcessorSupplier<? super K, ? super V> processorSupplier, String ... stateStoreNames) {
        this.delegate.process(processorSupplier, stateStoreNames);
    }

    public <K1, V1, V2> KStream<K, V2> join(GlobalKTable<K1, V1> globalKTable, KeyValueMapper<? super K, ? super V, ? extends K1> keyValueMapper, ValueJoiner<? super V, ? super V1, ? extends V2> joiner) {
        return this.delegate.join(globalKTable, keyValueMapper, joiner);
    }

    public <V1, R> C3Stream<K, R> join(KStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> joiner, JoinWindows windows) {
        return this.wrap(this.delegate.join(otherStream, joiner, windows));
    }

    public <V1, R> KStream<K, R> join(KStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> joiner, JoinWindows windows, Joined<K, V, V1> joined) {
        return this.wrap(this.delegate.join(otherStream, joiner, windows, joined));
    }

    public <V1, V2> KStream<K, V2> join(KTable<K, V1> table, ValueJoiner<? super V, ? super V1, ? extends V2> valueJoiner) {
        return this.wrap(this.delegate.join(table, valueJoiner));
    }

    public <V1, V2> KStream<K, V2> join(KTable<K, V1> table, ValueJoiner<? super V, ? super V1, ? extends V2> joiner, Joined<K, V, V1> joined) {
        return this.wrap(this.delegate.join(table, joiner, joined));
    }

    public <V1, R> C3Stream<K, R> outerJoin(C3Stream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, R> joiner, JoinWindows windows, Joined<K, V, V1> joined) {
        return this.wrap(this.delegate.outerJoin(otherStream.delegate, joiner, windows, joined));
    }

    public <V1, R> C3Stream<K, R> outerJoin(KStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> joiner, JoinWindows windows) {
        return this.wrap(this.delegate.outerJoin(otherStream, joiner, windows));
    }

    public <V1, R> KStream<K, R> outerJoin(KStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> joiner, JoinWindows windows, Joined<K, V, V1> joined) {
        return this.wrap(this.delegate.outerJoin(otherStream, joiner, windows, joined));
    }

    public <K1, V1, V2> KStream<K, V2> leftJoin(GlobalKTable<K1, V1> globalKTable, KeyValueMapper<? super K, ? super V, ? extends K1> keyValueMapper, ValueJoiner<? super V, ? super V1, ? extends V2> valueJoiner) {
        return this.delegate.leftJoin(globalKTable, keyValueMapper, valueJoiner);
    }

    public <V1, R> C3Stream<K, R> leftJoin(C3Stream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, R> joiner, JoinWindows windows) {
        return this.wrap(this.delegate.leftJoin(otherStream.delegate, joiner, windows));
    }

    public <V1, R> C3Stream<K, R> leftJoin(KStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> joiner, JoinWindows windows) {
        return this.wrap(this.delegate.leftJoin(otherStream, joiner, windows));
    }

    public <V1, R> KStream<K, R> leftJoin(KStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> joiner, JoinWindows windows, Joined<K, V, V1> joined) {
        return this.wrap(this.delegate.leftJoin(otherStream, joiner, windows, joined));
    }

    public <V1, V2> C3Stream<K, V2> leftJoin(KTable<K, V1> table, ValueJoiner<? super V, ? super V1, ? extends V2> joiner) {
        return this.wrap(this.delegate.leftJoin(table, joiner));
    }

    public <V1, V2> KStream<K, V2> leftJoin(KTable<K, V1> table, ValueJoiner<? super V, ? super V1, ? extends V2> joiner, Joined<K, V, V1> joined) {
        return this.wrap(this.delegate.leftJoin(table, joiner, joined));
    }

    public <K1> KGroupedStream<K1, V> groupBy(KeyValueMapper<? super K, ? super V, K1> selector) {
        return this.delegate.groupBy(selector);
    }

    public <K1> KGroupedStream<K1, V> groupBy(KeyValueMapper<? super K, ? super V, K1> selector, Serialized<K1, V> serialized) {
        return this.delegate.groupBy(selector, serialized);
    }

    public <K1> KGroupedStream<K1, V> groupBy(KeyValueMapper<? super K, ? super V, K1> selector, Grouped<K1, V> grouped) {
        return this.delegate.groupBy(selector, grouped);
    }

    public <K1> KGroupedStream<K1, V> groupBy(GroupBy<? super K, K1> groupBy, Serde<V> valSerde) {
        return this.flatMap(groupBy.keyValueMapper()).groupByKey(Serialized.with(groupBy.keySerde(), valSerde));
    }

    public <K1> KGroupedStream<K1, V> groupBy(GroupBy<? super K, K1> groupBy, TopicStoreMaster.Topic<?, V, ?, ?> throughTopic) {
        return this.flatMap(groupBy.keyValueMapper()).through(throughTopic.name, Produced.with(groupBy.keySerde(), throughTopic.valueSerde, groupBy.streamPartitioner())).groupByKey(Serialized.with(groupBy.keySerde(), throughTopic.valueSerde));
    }

    public KGroupedStream<K, V> groupByKey() {
        return this.delegate.groupByKey();
    }

    public KGroupedStream<K, V> groupByKey(Serialized<K, V> serialized) {
        return this.delegate.groupByKey(serialized);
    }

    public KGroupedStream<K, V> groupByKey(Grouped<K, V> grouped) {
        return this.delegate.groupByKey(grouped);
    }

    public C3Stream<K, V> peek(ForeachAction<? super K, ? super V> foreachAction) {
        return this.wrap(this.delegate.peek(foreachAction));
    }
}

