/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.Rollup;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.TopicStoreModule;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.streams.KafkaStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KafkaStreamsManager {
    private static final Logger log = LoggerFactory.getLogger(KafkaStreamsManager.class);
    private static final int STREAMS_CLOSE_TIMEOUT_SECONDS = 30;
    private final Provider<KafkaStreams> kafkaStreamsProvider;
    private final ExecutorService es;
    private final ImmutableSet<TopicStoreMaster.Store> stores;
    private final boolean enableSubTopologies;
    private final Object startStopLock = new Object();
    private final Object errorLock = new Object();
    private KafkaStreams currentStreams;
    private Throwable streamsError = null;
    private boolean started = false;

    @Inject
    public KafkaStreamsManager(Provider<KafkaStreams> kafkaStreamsProvider, @TopicStoreModule.AllStores ImmutableSet<TopicStoreMaster.Store> stores, @ControlCenterConfigModule.EnableSubTopologies boolean enableSubTopologies) {
        this.kafkaStreamsProvider = kafkaStreamsProvider;
        this.stores = stores;
        this.es = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("stream-manager-%d").build());
        this.enableSubTopologies = enableSubTopologies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KafkaStreams getKStreams() {
        Object object = this.startStopLock;
        synchronized (object) {
            return this.currentStreams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long allowance) throws Exception {
        long timeout = System.currentTimeMillis() + allowance;
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                this.currentStreams = (KafkaStreams)this.kafkaStreamsProvider.get();
                if (this.currentStreams == null) {
                    throw new RuntimeException("Kafka Stream failed to initialize");
                }
                Object object2 = this.errorLock;
                synchronized (object2) {
                    this.streamsError = null;
                    this.currentStreams.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new KafkaStreamsUncaughtExceptionHandler());
                    this.currentStreams.start();
                    HashSet toCheck = this.enableSubTopologies ? Sets.newHashSet() : Sets.newHashSet(this.stores);
                    int attempt = 0;
                    while (!toCheck.isEmpty() && this.streamsError == null) {
                        if (attempt++ > 5 || log.isDebugEnabled()) {
                            log.info("tocheck={}", (Object)toCheck);
                        }
                        KafkaStreams.State currentState = this.currentStreams.state();
                        log.info("streams in state={}", (Object)currentState);
                        log.info("tocheck={}", (Object)toCheck);
                        if (KafkaStreams.State.RUNNING.equals((Object)currentState)) {
                            for (TopicStoreMaster.Store storeDef : this.stores) {
                                if (!toCheck.contains(storeDef)) continue;
                                String storeName = storeDef.name;
                                if (storeDef.rollup) {
                                    storeName = TopicStoreMaster.nameJoin(storeDef.name, Rollup.ONE_MINUTE.name());
                                }
                                try {
                                    Object store = this.currentStreams.store(storeName, storeDef.queryableWindowStoreType == null ? storeDef.queryableKeyValueStoreType : storeDef.queryableWindowStoreType);
                                    if (store == null) continue;
                                    toCheck.remove(storeDef);
                                }
                                catch (Exception e) {
                                    log.debug("unable to get store name={} {}", (Object)storeDef.name, log.isTraceEnabled() ? e : "");
                                }
                            }
                        } else {
                            log.info("streams in state={}", (Object)currentState);
                        }
                        if (timeout < System.currentTimeMillis()) {
                            log.warn("unable to start with allowance={} missing stores={}", (Object)allowance, (Object)toCheck);
                            throw new TimeoutException();
                        }
                        this.errorLock.wait(TimeUnit.SECONDS.toMillis(1L));
                    }
                    if (this.streamsError != null) {
                        throw new RuntimeException("Error encountered during streams startup", this.streamsError);
                    }
                }
                this.started = true;
            } else {
                log.debug("Kafka Streams already running");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort(Throwable err) {
        this.maybeInterruptStartup(err);
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.started) {
                try {
                    log.info("Attempting clean shutdown of Kafka Streams");
                    this.stop();
                }
                catch (Exception e) {
                    log.error("Error closing Kafka Streams", (Throwable)e);
                }
                log.error("Kafka Streams encountered an unexpected error, shutting down");
            }
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInterruptStartup(Throwable err) {
        Object object = this.errorLock;
        synchronized (object) {
            if (this.streamsError == null) {
                this.streamsError = err;
                this.errorLock.notifyAll();
            }
        }
    }

    public void close() {
        this.maybeInterruptStartup(new RuntimeException("Kafka Streams startup interrupted"));
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            log.info("Shutting down Kafka Streams");
            if (this.currentStreams != null) {
                if (this.currentStreams.close(30L, TimeUnit.SECONDS)) {
                    log.info("Successfully closed Kafka Streams");
                    this.currentStreams = null;
                    this.started = false;
                } else {
                    log.error("Closing Kafka Streams did not finish within [{}] seconds", (Object)30);
                }
            }
            this.es.shutdownNow();
        }
    }

    private final class KafkaStreamsUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private KafkaStreamsUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, final Throwable e) {
            log.error("streams exception", e);
            KafkaStreamsManager.this.es.submit(new Runnable(){

                @Override
                public void run() {
                    KafkaStreamsManager.this.abort(e);
                }
            });
        }
    }
}

