/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import com.google.common.io.Files;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.streams.RocksDBConfigurator;
import io.confluent.controlcenter.streams.SingleGroupPartitionGrouper;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.WindowExtractor;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsConfigModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(StreamsConfigModule.class);

    protected void configure() {
    }

    @Provides
    @Inject
    @Singleton
    protected StreamsConfig provideMonitoringStreamsConfig(ControlCenterConfig controlCenterConfig, @ControlCenterConfigModule.EnableSubTopologies boolean enableSubTopologies, @StreamsStateDir Path streamsStateDir) {
        Properties props = new Properties();
        props.put("bootstrap.servers", controlCenterConfig.getList("bootstrap.servers"));
        props.put("state.dir", streamsStateDir.toString());
        String streamsAppId = TopicStoreMaster.nameJoin(controlCenterConfig.getString("confluent.controlcenter.name"), controlCenterConfig.getString("confluent.controlcenter.id"));
        props.put("application.id", streamsAppId);
        props.put("default.timestamp.extractor", WindowExtractor.class);
        props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "earliest");
        props.put("buffered.records.per.partition", (Object)100);
        props.put(StreamsConfig.consumerPrefix((String)"max.poll.records"), (Object)100);
        props.put(StreamsConfig.consumerPrefix((String)"max.poll.interval.ms"), (Object)((int)TimeUnit.HOURS.toMillis(6L)));
        props.put("replication.factor", (Object)controlCenterConfig.getInt("confluent.controlcenter.internal.topics.replication"));
        props.put(StreamsConfig.producerPrefix((String)"acks"), "all");
        props.put(StreamsConfig.producerPrefix((String)"max.request.size"), (Object)0xA00000);
        props.put("default.deserialization.exception.handler", LogAndContinueExceptionHandler.class.getName());
        props.putAll((Map<?, ?>)controlCenterConfig.valuesWithPrefix("confluent.controlcenter.streams."));
        props.putAll((Map<?, ?>)controlCenterConfig.originalsWithPrefix("confluent.controlcenter.streams."));
        if (enableSubTopologies) {
            props.put("partition.grouper", SingleGroupPartitionGrouper.class);
        }
        props.put("rocksdb.config.setter", RocksDBConfigurator.class);
        props.put("topology.optimization", "all");
        String securityProtocol = props.getProperty("security.protocol");
        if ("PLAINTEXT".equals(securityProtocol)) {
            log.info("You are connecting to an insecure cluster. If you'd like to secure Control Center please visit https://docs.confluent.io/current/control-center/docs/security.html?utm_source=control-center&utm_medium=logs&utm_campaign=security");
        }
        return new StreamsConfig((Map)props);
    }

    @Provides
    @Inject
    @StreamsStateDir
    protected Path getStreamsStateDir(ControlCenterConfig controlCenterConfig) throws IOException {
        Path streamsStateDir = Paths.get(controlCenterConfig.getString("confluent.controlcenter.data.dir"), controlCenterConfig.getString("confluent.controlcenter.id"), "kafka-streams");
        Files.createParentDirs((File)streamsStateDir.toFile());
        return streamsStateDir;
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface StreamsStateDir {
    }
}

