/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.alert;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Provider;
import io.confluent.command.record.Command;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.alert.AlertUtil;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.util.KvQuery;
import io.confluent.monitoring.common.Clock;
import io.confluent.monitoring.common.TimeBucket;
import io.confluent.serializers.OrderedKeyUberSerde;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertTransformerSupplier
implements TransformerSupplier<Object, Controlcenter.TriggerEvent, KeyValue<Void, Iterable<KeyValue<Alert.AlertInfo, Alert.AlertInfo>>>> {
    private static final Logger log = LoggerFactory.getLogger(AlertTransformerSupplier.class);
    private static final long PUNCTUATE_INTERVAL_MS = TimeBucket.SIZE;
    private static final long DEFAULT_MAX_PUNCTUATE_MS = TimeUnit.SECONDS.toMillis(1L);
    private final long maxTriggerEventsInOneAlert;
    private final String storeName;
    private final String triggerEventsStoreName;
    private final Clock clock;
    private final OrderedKeyUberSerde<Controlcenter.TriggerEventKey> actionsKeySerde;
    private final Provider<? extends ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> triggerConfigsProvider;
    private final Provider<? extends ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> actionConfigsProvider;

    public AlertTransformerSupplier(String storeName, String triggerEventsStoreName, int maxTriggerEventsInOneAlert, Clock clock, OrderedKeyUberSerde<Controlcenter.TriggerEventKey> actionsKeySerde, Provider<? extends ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> triggerConfigsProvider, Provider<? extends ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> actionConfigsProvider) {
        this.storeName = storeName;
        this.triggerEventsStoreName = triggerEventsStoreName;
        this.clock = clock;
        this.maxTriggerEventsInOneAlert = maxTriggerEventsInOneAlert;
        this.actionsKeySerde = actionsKeySerde;
        this.triggerConfigsProvider = triggerConfigsProvider;
        this.actionConfigsProvider = actionConfigsProvider;
    }

    public Transformer<Object, Controlcenter.TriggerEvent, KeyValue<Void, Iterable<KeyValue<Alert.AlertInfo, Alert.AlertInfo>>>> get() {
        return new AlertTransformer(PUNCTUATE_INTERVAL_MS, DEFAULT_MAX_PUNCTUATE_MS);
    }

    class AlertTransformer
    implements Transformer<Object, Controlcenter.TriggerEvent, KeyValue<Void, Iterable<KeyValue<Alert.AlertInfo, Alert.AlertInfo>>>> {
        private final long maxPunctuateMs;
        private final long punctuateIntervalMs;
        private ProcessorContext context;
        private long approxC3Time = 0L;
        private KeyValueStore<Bytes, Controlcenter.TriggerActions> kvStore;
        private KeyValueStore<Bytes, Controlcenter.VerifiableTriggerInfo> kvTriggerEventStore;
        private long lastPunctuateTimeMs = -1L;
        private Bytes lastPunctuateKey = null;
        private final OrderedKeyUberSerde<Controlcenter.TriggerEventKey> actionStartKeySerde = AlertTransformerSupplier.access$000(AlertTransformerSupplier.this).prefixKeySerde(3);
        private final OrderedKeyUberSerde<Controlcenter.TriggerEventKey> actionPrefixKeySerde = AlertTransformerSupplier.access$000(AlertTransformerSupplier.this).prefixKeySerde(2);

        public AlertTransformer(long punctuateIntervalMs, long maxPunctuateMs) {
            this.punctuateIntervalMs = punctuateIntervalMs;
            this.maxPunctuateMs = maxPunctuateMs;
        }

        public void init(ProcessorContext context) {
            this.context = context;
            this.kvStore = (KeyValueStore)this.context.getStateStore(AlertTransformerSupplier.this.storeName);
            this.kvTriggerEventStore = (KeyValueStore)this.context.getStateStore(AlertTransformerSupplier.this.triggerEventsStoreName);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public KeyValue<Void, Iterable<KeyValue<Alert.AlertInfo, Alert.AlertInfo>>> transform(Object key, Controlcenter.TriggerEvent triggerEvent) {
            if (triggerEvent.getTimestamp() > this.approxC3Time) {
                this.approxC3Time = triggerEvent.getTimestamp();
            }
            if (triggerEvent.getHeartbeat()) {
                log.trace("Alert heartbeat with timestamp={}", (Object)triggerEvent.getTimestamp());
                return this.punctuate(this.approxC3Time);
            }
            Controlcenter.TriggerEventKey triggerEventKey = Controlcenter.TriggerEventKey.newBuilder().setTriggerGuid(triggerEvent.getTriggerGuid()).setComponent(AlertUtil.getComponentForKey(triggerEvent.getInfo().getComponent())).build();
            Bytes storeKey = this.actionPrefixKeySerde.key((Object)triggerEventKey);
            log.trace("Alert transform storeKey={} trigger event={}", (Object)storeKey, (Object)triggerEvent);
            ArrayList<KeyValue<Alert.AlertInfo, Alert.AlertInfo>> ret = new ArrayList<KeyValue<Alert.AlertInfo, Alert.AlertInfo>>();
            try (KeyValueIterator configIterator = ((ReadOnlyKeyValueStore)AlertTransformerSupplier.this.actionConfigsProvider.get()).all();){
                ArrayList actionConfigs = Lists.newArrayList((Iterator)configIterator);
                Controlcenter.TriggerActions storedActions = (Controlcenter.TriggerActions)this.kvStore.get((Object)storeKey);
                Command.CommandMessage triggerMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)AlertTransformerSupplier.this.triggerConfigsProvider.get()).get((Object)Command.CommandKey.newBuilder().setGuid(triggerEvent.getTriggerGuid()).setConfigType(Command.CommandConfigType.MONITORING_TRIGGER_CONFIG).build());
                Controlcenter.TriggerActions actions = AlertUtil.updateTriggerActionsFromConfig(triggerEvent.getTriggerGuid(), triggerEvent.getInfo().getComponent(), storedActions, triggerMessage, actionConfigs);
                if (actions == null) {
                    log.trace("Ignoring trigger event={} for trigger GUID={}, no actions/trigger defined", (Object)triggerEvent, (Object)triggerEvent.getTriggerGuid());
                    if (storedActions != null) {
                        this.cleanupTriggerState(triggerEvent.getTriggerGuid(), triggerEvent.getInfo().getComponent(), storeKey);
                    }
                    KeyValue<Void, Iterable<KeyValue<Alert.AlertInfo, Alert.AlertInfo>>> keyValue = null;
                    return keyValue;
                }
                log.trace("Actions for trigger={}: {}", (Object)triggerEvent.getTriggerGuid(), (Object)actions);
                actions = this.maybeCreateAlerts(this.approxC3Time, triggerEvent, actions, ret);
                if (!actions.equals((Object)storedActions)) {
                    log.trace("Store trigger guid={}, actions={}", (Object)triggerEvent.getTriggerGuid(), (Object)actions);
                    this.kvStore.put((Object)storeKey, (Object)actions);
                }
            }
            catch (Exception e) {
                log.warn("Failed to update trigger event store. May not send an alert when needed.", (Throwable)e);
            }
            KeyValue<Void, Iterable<KeyValue<Alert.AlertInfo, Alert.AlertInfo>>> pair = this.punctuate(this.approxC3Time);
            if (pair != null) {
                Iterables.addAll(ret, (Iterable)((Iterable)pair.value));
            }
            if (ret.size() != 0) return KeyValue.pair(null, ret);
            return null;
        }

        KeyValue<Void, Iterable<KeyValue<Alert.AlertInfo, Alert.AlertInfo>>> punctuate(long timestamp) {
            if (this.lastPunctuateTimeMs < 0L) {
                this.lastPunctuateTimeMs = timestamp;
            }
            if (timestamp - this.lastPunctuateTimeMs < this.punctuateIntervalMs) {
                return null;
            }
            long now = AlertTransformerSupplier.this.clock.currentTimeMillis();
            this.lastPunctuateTimeMs = timestamp;
            long punctuateTimeout = now + this.maxPunctuateMs;
            ArrayList<KeyValue<Alert.AlertInfo, Alert.AlertInfo>> alertList = new ArrayList<KeyValue<Alert.AlertInfo, Alert.AlertInfo>>();
            try (KeyValueIterator<Bytes, Controlcenter.TriggerActions> iter = KvQuery.rangeFrom(this.kvStore, this.lastPunctuateKey);){
                long count = 0L;
                while (iter.hasNext()) {
                    KeyValue entry = (KeyValue)iter.next();
                    if (entry == null) continue;
                    if (entry.value == null) {
                        log.debug("removing null value key={} from store={}", entry.key, (Object)AlertTransformerSupplier.this.storeName);
                        this.kvStore.delete(entry.key);
                    } else {
                        ArrayList actionConfigs;
                        log.trace("checking key={} trigger guid={} store={}", new Object[]{entry.key, ((Controlcenter.TriggerActions)entry.value).getTriggerGuid(), AlertTransformerSupplier.this.storeName});
                        Command.CommandMessage triggerMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)AlertTransformerSupplier.this.triggerConfigsProvider.get()).get((Object)Command.CommandKey.newBuilder().setGuid(((Controlcenter.TriggerActions)entry.value).getTriggerGuid()).setConfigType(Command.CommandConfigType.MONITORING_TRIGGER_CONFIG).build());
                        try (KeyValueIterator actionConfigIterator = ((ReadOnlyKeyValueStore)AlertTransformerSupplier.this.actionConfigsProvider.get()).all();){
                            actionConfigs = Lists.newArrayList((Iterator)actionConfigIterator);
                        }
                        Controlcenter.TriggerActions modifiedActions = AlertUtil.updateTriggerActionsFromConfig(((Controlcenter.TriggerActions)entry.value).getTriggerGuid(), ((Controlcenter.TriggerActions)entry.value).getComponent(), (Controlcenter.TriggerActions)entry.value, triggerMessage, actionConfigs);
                        if (modifiedActions != null) {
                            if (!(modifiedActions = this.maybeCreateAlerts(timestamp, null, modifiedActions, alertList)).equals(entry.value)) {
                                log.trace("Update key={} trigger actions={}", entry.key, (Object)modifiedActions);
                                this.kvStore.put(entry.key, (Object)modifiedActions);
                            }
                        } else {
                            this.cleanupTriggerState(((Controlcenter.TriggerActions)entry.value).getTriggerGuid(), ((Controlcenter.TriggerActions)entry.value).getComponent(), (Bytes)entry.key);
                        }
                    }
                    this.lastPunctuateKey = (Bytes)entry.key;
                    ++count;
                    if (AlertTransformerSupplier.this.clock.currentTimeMillis() > punctuateTimeout) {
                        log.debug("stopping punctuate at key={} store={}", (Object)this.lastPunctuateKey, (Object)AlertTransformerSupplier.this.storeName);
                        break;
                    }
                    if (!iter.hasNext()) {
                        log.debug("finished all punctuation for store={}", (Object)AlertTransformerSupplier.this.storeName);
                        this.lastPunctuateKey = null;
                    }
                    log.debug("punctuated on count={} records", (Object)count);
                }
            }
            catch (Exception e) {
                log.error("failure during punctuate for store={}", (Object)AlertTransformerSupplier.this.storeName, (Object)e);
            }
            if (alertList.isEmpty()) {
                return null;
            }
            return KeyValue.pair(null, alertList);
        }

        public void close() {
            log.info("closing store={}", (Object)AlertTransformerSupplier.this.storeName);
        }

        private void cleanupTriggerState(String triggerGuid, Alert.ComponentDesc componentDesc, Bytes kvStoreKey) {
            Controlcenter.TriggerEventKey triggerEventStartKey = this.getTriggerEventStartKey(triggerGuid, componentDesc, 0L);
            Bytes start = this.actionStartKeySerde.key((Object)triggerEventStartKey);
            Bytes prefix = this.actionPrefixKeySerde.key((Object)triggerEventStartKey);
            try (KeyValueIterator<Bytes, Controlcenter.VerifiableTriggerInfo> iter = KvQuery.prefixScan(this.kvTriggerEventStore, prefix, start);){
                while (iter.hasNext()) {
                    KeyValue entry = (KeyValue)iter.next();
                    this.kvTriggerEventStore.delete(entry.key);
                    log.trace("Successfuly removed trigger event={}, trigger guid={} for removed/disabled trigger/action", entry.value, (Object)triggerGuid);
                }
                this.kvStore.delete((Object)kvStoreKey);
                log.trace("Removed trigger state in store={} for trigger={}", (Object)AlertTransformerSupplier.this.storeName, (Object)triggerGuid);
            }
            catch (Exception e) {
                log.error("Failed to remove all trigger events for trigger={}", (Object)triggerGuid, (Object)e);
            }
        }

        private Controlcenter.TriggerActions maybeCreateAlerts(long currentTime, Controlcenter.TriggerEvent triggerEvent, Controlcenter.TriggerActions actions, List<KeyValue<Alert.AlertInfo, Alert.AlertInfo>> alertList) {
            long nextTriggerInfoSequence = triggerEvent == null ? actions.getNextTriggerInfoSequence() : actions.getNextTriggerInfoSequence() + 1L;
            SortedMap<Long, Alert.TriggerInfo> sequenceToTriggerMap = this.getActionableTriggerEvents(currentTime, actions, nextTriggerInfoSequence);
            if (triggerEvent == null && (sequenceToTriggerMap == null || sequenceToTriggerMap.isEmpty())) {
                log.trace("No actionable trigger events for trigger guid={}", (Object)actions.getTriggerGuid());
                return actions;
            }
            Controlcenter.TriggerActions.Builder actionsBuilder = Controlcenter.TriggerActions.newBuilder((Controlcenter.TriggerActions)actions);
            boolean triggerEventInMap = false;
            if (triggerEvent != null && this.needKeepTriggerEvent(currentTime, actions)) {
                long nextSequence = actions.getNextTriggerInfoSequence();
                this.keepTriggerEvent(currentTime, triggerEvent, nextSequence);
                actionsBuilder.setNextTriggerInfoSequence(nextSequence + 1L);
                sequenceToTriggerMap.put(nextSequence, triggerEvent.getInfo());
                triggerEventInMap = true;
            }
            long lastSequenceOfTriggerEvents = sequenceToTriggerMap.isEmpty() ? -1L : sequenceToTriggerMap.lastKey();
            for (int i = 0; i < actions.getActionsCount(); ++i) {
                Collection<Alert.TriggerInfo> triggerList;
                Controlcenter.TriggerAction action = actions.getActions(i);
                if (!this.canSendAlert(action, currentTime, nextTriggerInfoSequence) || (triggerList = sequenceToTriggerMap.tailMap(action.getLastTriggerInfoSequence() + 1L).values()).isEmpty() && triggerEvent == null) continue;
                Command.CommandMessage triggerMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)AlertTransformerSupplier.this.triggerConfigsProvider.get()).get((Object)Command.CommandKey.newBuilder().setGuid(actions.getTriggerGuid()).setConfigType(Command.CommandConfigType.MONITORING_TRIGGER_CONFIG).build());
                if (triggerMessage == null) {
                    log.warn("unable to find trigger config with guid={}", (Object)actions.getTriggerGuid());
                    continue;
                }
                CommandAlert.MonitoringTriggerConfig monitoringTriggerConfig = triggerMessage.getMonitoringTriggerConfig();
                if (!monitoringTriggerConfig.getGuid().equals(actions.getTriggerGuid())) {
                    log.warn("mismatching guids action={} trigger={}", (Object)actions.getTriggerGuid(), (Object)monitoringTriggerConfig.getGuid());
                    continue;
                }
                Alert.AlertInfo.Builder alertBuilder = Alert.AlertInfo.newBuilder().setGuid(UUID.randomUUID().toString()).setTimestamp(currentTime).setMonitoringTrigger(monitoringTriggerConfig).addAllActions((Iterable)action.getActionsList()).addAllTriggers(triggerList);
                if (triggerEvent != null && !triggerEventInMap) {
                    alertBuilder.addTriggers(Alert.TriggerInfo.newBuilder((Alert.TriggerInfo)triggerEvent.getInfo()));
                }
                Alert.AlertInfo alert = alertBuilder.build();
                log.debug("Created alert={}", (Object)alert);
                alertList.add((KeyValue<Alert.AlertInfo, Alert.AlertInfo>)KeyValue.pair((Object)alert, (Object)alert));
                long nextActionTimestamp = AlertUtil.computeNextActionTimestamp(action, currentTime);
                if ((long)triggerList.size() >= AlertTransformerSupplier.this.maxTriggerEventsInOneAlert) {
                    nextActionTimestamp = action.getNextActionTimestamp();
                }
                long lastSequence = lastSequenceOfTriggerEvents >= 0L ? lastSequenceOfTriggerEvents : action.getLastTriggerInfoSequence();
                actionsBuilder.setActions(i, action.toBuilder().setLastTriggerInfoSequence(lastSequence).setNextActionTimestamp(nextActionTimestamp));
            }
            return actionsBuilder.build();
        }

        private void keepTriggerEvent(long currentTime, Controlcenter.TriggerEvent triggerEvent, long sequence) {
            Controlcenter.TriggerEventKey triggerEventKey = Controlcenter.TriggerEventKey.newBuilder().setTriggerGuid(triggerEvent.getTriggerGuid()).setComponent(AlertUtil.getComponentForKey(triggerEvent.getInfo().getComponent())).setTimestamp(currentTime).setWindow(triggerEvent.getInfo().getWindow()).build();
            Bytes key = AlertTransformerSupplier.this.actionsKeySerde.key((Object)triggerEventKey);
            Controlcenter.VerifiableTriggerInfo value = Controlcenter.VerifiableTriggerInfo.newBuilder().setSequence(sequence).setInfo(Alert.TriggerInfo.newBuilder((Alert.TriggerInfo)triggerEvent.getInfo())).build();
            log.trace("Store trigger event={}", (Object)value);
            this.kvTriggerEventStore.put((Object)key, (Object)value);
        }

        private boolean canSendAlert(Controlcenter.TriggerAction action, long currentTime, long nextSequence) {
            return currentTime >= action.getNextActionTimestamp() || nextSequence - action.getLastTriggerInfoSequence() - 1L >= AlertTransformerSupplier.this.maxTriggerEventsInOneAlert;
        }

        private SortedMap<Long, Alert.TriggerInfo> getActionableTriggerEvents(long currentTime, Controlcenter.TriggerActions actions, long nextTriggerInfoSequence) {
            long earliestTimestamp = Long.MAX_VALUE;
            long earliestLastTriggerInfoSequence = Long.MAX_VALUE;
            long earliestNonAlertableLastTriggerSequence = Long.MAX_VALUE;
            for (int i = 0; i < actions.getActionsCount(); ++i) {
                Controlcenter.TriggerAction action = actions.getActions(i);
                if (this.canSendAlert(action, currentTime, nextTriggerInfoSequence)) {
                    long ts = Math.max(0L, action.getNextActionTimestamp() - action.getIntervalMs());
                    earliestTimestamp = Math.min(earliestTimestamp, ts);
                    earliestLastTriggerInfoSequence = Math.min(earliestLastTriggerInfoSequence, action.getLastTriggerInfoSequence());
                    continue;
                }
                earliestNonAlertableLastTriggerSequence = Math.min(earliestNonAlertableLastTriggerSequence, action.getLastTriggerInfoSequence());
            }
            Controlcenter.TriggerEventKey triggerEventStartKey = this.getTriggerEventStartKey(actions.getTriggerGuid(), actions.getComponent(), earliestTimestamp);
            Bytes start = this.actionStartKeySerde.key((Object)triggerEventStartKey);
            Bytes prefix = this.actionPrefixKeySerde.key((Object)triggerEventStartKey);
            TreeMap<Long, Alert.TriggerInfo> sequenceToTriggerMap = new TreeMap<Long, Alert.TriggerInfo>();
            try (KeyValueIterator<Bytes, Controlcenter.VerifiableTriggerInfo> iter = KvQuery.prefixScan(this.kvTriggerEventStore, prefix, start);){
                while (iter.hasNext()) {
                    KeyValue entry = (KeyValue)iter.next();
                    long sequence = ((Controlcenter.VerifiableTriggerInfo)entry.value).getSequence();
                    if (sequence > earliestLastTriggerInfoSequence) {
                        sequenceToTriggerMap.put(sequence, ((Controlcenter.VerifiableTriggerInfo)entry.value).getInfo());
                    }
                    if (sequence > earliestNonAlertableLastTriggerSequence) continue;
                    this.kvTriggerEventStore.delete(entry.key);
                }
            }
            catch (NullPointerException npe) {
                log.error("Unexpected null value in a trigger event store for trigger={}", (Object)actions.getTriggerGuid(), (Object)npe);
            }
            catch (Exception e) {
                log.error("Failed to retrieve trigger events, may fail to create alert for trigger={}", (Object)actions.getTriggerGuid(), (Object)e);
            }
            return sequenceToTriggerMap;
        }

        private boolean needKeepTriggerEvent(long currentTime, Controlcenter.TriggerActions actions) {
            for (int i = 0; i < actions.getActionsCount(); ++i) {
                Controlcenter.TriggerAction action = actions.getActions(i);
                if (currentTime >= action.getNextActionTimestamp()) continue;
                return true;
            }
            return false;
        }

        private Controlcenter.TriggerEventKey getTriggerEventStartKey(String triggerGuid, Alert.ComponentDesc componentDesc, long earliestTimestamp) {
            Controlcenter.TriggerEventKey.Builder triggerEventKeyBuilder = Controlcenter.TriggerEventKey.newBuilder();
            Controlcenter.TriggerEventKey key = triggerEventKeyBuilder.setTriggerGuid(triggerGuid).setComponent(AlertUtil.getComponentForKey(componentDesc)).setTimestamp(earliestTimestamp).build();
            triggerEventKeyBuilder.clear();
            return key;
        }
    }
}

