/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.group;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import io.confluent.controlcenter.record.Controlcenter;
import java.util.Collection;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;

public class WindowedGroupingAggregator
implements Aggregator<Bytes, Controlcenter.WindowedGrouping, Controlcenter.WindowedGrouping> {
    public static final int DEFAULT_MAX_MEMBERS_DIFF = 64;
    public static final int DEFAULT_CACHE_SIZE = 8192;
    private final Cache<Bytes, Integer> memberListSize;
    private final int maxMembersDiff;

    public WindowedGroupingAggregator() {
        this(64, 8192);
    }

    protected WindowedGroupingAggregator(int maxMembersDiff, int cacheSize) {
        this.maxMembersDiff = maxMembersDiff;
        this.memberListSize = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
    }

    public Controlcenter.WindowedGrouping apply(Bytes aggKey, Controlcenter.WindowedGrouping value, Controlcenter.WindowedGrouping aggregate) {
        Controlcenter.WindowedGrouping.Builder builder = Controlcenter.WindowedGrouping.newBuilder((Controlcenter.WindowedGrouping)aggregate).setWindow(value.getWindow());
        Integer lastMemberListSize = (Integer)this.memberListSize.getIfPresent((Object)aggKey);
        Integer n = lastMemberListSize = lastMemberListSize == null ? Integer.valueOf(1) : lastMemberListSize;
        if (value.getMembersCount() > 0 && (value.getMembersCount() > this.maxMembersDiff || aggregate.getMembersCount() >= lastMemberListSize + this.maxMembersDiff)) {
            builder.clearMembers();
            builder.addAllMembers(WindowedGroupingAggregator.uniqueMemberInfos(value.getMembersList(), aggregate.getMembersList()));
            this.memberListSize.put((Object)aggKey, (Object)builder.getMembersCount());
        } else {
            for (Controlcenter.MemberInfo mi : value.getMembersList()) {
                builder.addMembers(mi);
            }
        }
        return builder.build();
    }

    public static Collection<? extends Controlcenter.MemberInfo> uniqueMemberInfos(Iterable<? extends Controlcenter.MemberInfo> ... iters) {
        ImmutableSet.Builder memberInfos = ImmutableSet.builder();
        for (Iterable<? extends Controlcenter.MemberInfo> mis : iters) {
            if (mis == null) continue;
            memberInfos.addAll(mis);
        }
        return memberInfos.build();
    }
}

