/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.verify;

import com.google.common.base.MoreObjects;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.monitoring.record.Monitoring;
import java.util.Objects;

public class SequenceWithMetadata
implements Comparable<SequenceWithMetadata> {
    private final long sequence;
    private final long timestamp;
    private final long minWindow;
    private final long maxWindow;

    public SequenceWithMetadata(long sequence, long timestamp, long minWindow, long maxWindow) {
        this.sequence = sequence;
        this.timestamp = timestamp;
        this.minWindow = minWindow;
        this.maxWindow = maxWindow;
    }

    public SequenceWithMetadata(Monitoring.MonitoringMessage monitoringMessage, long timestamp) {
        this(monitoringMessage.getSequence(), timestamp, monitoringMessage.getMinWindow(), monitoringMessage.getMaxWindow());
    }

    public SequenceWithMetadata(Controlcenter.SequenceInfo info) {
        this(info.getSequence(), info.getTimestamp(), info.getMinWindow(), info.getMaxWindow());
    }

    public SequenceWithMetadata(long sequence) {
        this(sequence, -1L, -1L, -1L);
    }

    public SequenceWithMetadata(long sequence, Long timestamp) {
        this(sequence, timestamp, -1L, -1L);
    }

    public SequenceWithMetadata nextWithTimestamp(Long timestamp) {
        return new SequenceWithMetadata(this.nextSequence(), timestamp);
    }

    public SequenceWithMetadata previousWithTimestamp(Long timestamp) {
        return this.sequence <= 0L ? null : new SequenceWithMetadata(this.sequence - 1L, timestamp);
    }

    public SequenceWithMetadata withMinMaxWindow(Long window) {
        return new SequenceWithMetadata(this.sequence, this.timestamp, window, window);
    }

    public Controlcenter.SequenceInfo toSequenceInfo() {
        return Controlcenter.SequenceInfo.newBuilder().setSequence(this.sequence).setTimestamp(this.timestamp).setMinWindow(this.minWindow).setMaxWindow(this.maxWindow).build();
    }

    public long sequence() {
        return this.sequence;
    }

    public long nextSequence() {
        return this.sequence + 1L;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long minWindow() {
        return this.minWindow;
    }

    public long maxWindow() {
        return this.maxWindow;
    }

    @Override
    public int compareTo(SequenceWithMetadata sequenceWithMetadata) {
        if (this == sequenceWithMetadata) {
            return 0;
        }
        return Long.compare(this.sequence, sequenceWithMetadata.sequence);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceWithMetadata other = (SequenceWithMetadata)o;
        return Objects.equals(this.sequence, other.sequence) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.minWindow, other.minWindow) && Objects.equals(this.maxWindow, other.maxWindow);
    }

    public int hashCode() {
        return Objects.hash(this.sequence, this.timestamp, this.minWindow, this.maxWindow);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sequence", this.sequence).add("timestamp", this.timestamp).add("minWindow", this.minWindow).add("maxWindow", this.maxWindow).toString();
    }
}

