/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.tools;

import com.google.common.base.Joiner;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.confluent.controlcenter.BootstrapClientSupplier;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.KafkaHelper;
import io.confluent.controlcenter.serialization.SerializationModule;
import io.confluent.controlcenter.streams.StreamsConfigModule;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.TopicStoreModule;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import kafka.tools.StreamsResetter;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.streams.StreamsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resetter {
    private static final Logger log = LoggerFactory.getLogger(Resetter.class);
    protected final ControlCenterConfig config;
    protected final TopicStoreMaster topicStoreMaster;
    protected final StreamsConfig streamsConfig;
    protected final StreamsResetter streamsResetter;
    protected final KafkaHelper kafkaHelper;

    @Inject
    public Resetter(ControlCenterConfig config, TopicStoreMaster topicStoreMaster, StreamsConfig streamsConfig, StreamsResetter streamsResetter, BootstrapClientSupplier bootstrapClientSupplier) {
        this.config = config;
        this.streamsConfig = streamsConfig;
        this.topicStoreMaster = topicStoreMaster;
        this.streamsResetter = streamsResetter;
        this.kafkaHelper = new KafkaHelper(bootstrapClientSupplier.get());
    }

    public int run() {
        Joiner joiner = Joiner.on((String)",");
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("--zookeeper");
        argsList.add(this.config.getString("zookeeper.connect"));
        argsList.add("--bootstrap-servers");
        argsList.add(joiner.join((Iterable)this.config.getList("bootstrap.servers")));
        argsList.add("--application-id");
        argsList.add(this.streamsConfig.getString("application.id"));
        argsList.add("--input-topics");
        argsList.add(joiner.join(this.topicStoreMaster.getInputTopicNames()));
        argsList.add("--intermediate-topics");
        argsList.add(joiner.join(this.topicStoreMaster.getIntermediateTopicNames()));
        int exit = this.streamsResetter.run(argsList.toArray(new String[0]));
        if (exit != 0) {
            return exit;
        }
        System.out.println("Deleting intermediate topics");
        for (String topic : this.topicStoreMaster.getIntermediateTopicNames()) {
            this.deleteTopic(topic);
        }
        System.out.println("Done");
        this.deleteLocalData();
        return 0;
    }

    private void deleteLocalData() {
        Path dataDir = Paths.get(this.config.getString("confluent.controlcenter.data.dir"), this.config.getString("confluent.controlcenter.id"));
        System.out.println("Deleting local RocksDB data in " + dataDir.toAbsolutePath());
        try {
            Files.walkFileTree(dataDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            System.out.println("Done");
        }
        catch (NoSuchFileException e) {
            System.out.println("Does not exist");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean deleteTopic(String topic) {
        try {
            this.kafkaHelper.deleteTopic(topic);
        }
        catch (UnknownTopicOrPartitionException e) {
            return false;
        }
        catch (Throwable e) {
            log.error("ERROR: Deleting topic {} failed.", (Object)topic, (Object)e);
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("You must provide a path to the config file");
            System.exit(1);
        }
        ControlCenterConfig config = new ControlCenterConfig(args[0]);
        Injector injector = Guice.createInjector((Module[])new Module[]{new ControlCenterConfigModule(config), new StreamsConfigModule(), new SerializationModule(), new TopicStoreModule()});
        Resetter resetter = (Resetter)injector.getInstance(Resetter.class);
        System.exit(resetter.run());
    }
}

