/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.tools;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.serialization.SerializationModule;
import io.confluent.controlcenter.streams.StreamsConfigModule;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.TopicStoreModule;
import java.io.PrintStream;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class Topics {
    private static final Joiner JOINER = Joiner.on((String)" ");
    private static final String NEWLINE = System.lineSeparator();
    private final TopicStoreMaster topicStoreMaster;
    private final StreamsConfig streamsConfig;

    @Inject
    public Topics(TopicStoreMaster topicStoreMaster, StreamsConfig streamsConfig) {
        this.topicStoreMaster = topicStoreMaster;
        this.streamsConfig = streamsConfig;
    }

    public String getEnv() {
        return "APP_ID=" + this.streamsConfig.getString("application.id") + NEWLINE + ("INPUT_TOPICS=\"" + JOINER.join((Iterable)Sets.newTreeSet(this.topicStoreMaster.getInputTopicNames())) + "\"") + NEWLINE + ("INTERNAL_TOPICS=\"" + JOINER.join((Iterable)Sets.newTreeSet(this.topicStoreMaster.getInternalTopicNames())) + "\"") + NEWLINE;
    }

    void printEnv(PrintStream out) {
        out.print(this.getEnv());
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("You must provide a path to the config file");
            System.exit(1);
        }
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.removeAllAppenders();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout(), "System.err"));
        ControlCenterConfig config = new ControlCenterConfig(args[0]);
        ((Topics)Guice.createInjector((Module[])new Module[]{new ControlCenterConfigModule(config), new StreamsConfigModule(), new TopicStoreModule(), new SerializationModule()}).getInstance(Topics.class)).printEnv(System.out);
    }
}

