/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConfigUtils {
    private static final Joiner JOINER = Joiner.on((char)',');

    public static List<String> getList(Map<String, Object> config, String key) {
        Object value = config.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof List || List.class.isAssignableFrom(value.getClass())) {
            return (List)value;
        }
        return ConfigUtils.toList(value.toString());
    }

    public static List<String> toList(String value) {
        Preconditions.checkNotNull((Object)value);
        return Arrays.asList(value.split(","));
    }

    public static String toString(List<String> values) {
        Preconditions.checkNotNull(values);
        return JOINER.join(values);
    }
}

