/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.state.KeyValueIterator;

public class FilteredKeyValueIterator<K, V>
implements KeyValueIterator<K, V> {
    private KeyValueIterator<K, V> delegate;
    private Predicate<? super K, ? super V> predicate;
    private KeyValue<K, V> current;

    public FilteredKeyValueIterator(KeyValueIterator<K, V> delegate, Predicate<? super K, ? super V> predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public void close() {
        this.current = null;
        this.delegate.close();
    }

    public K peekNextKey() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (K)this.current.key;
    }

    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        if (!this.delegate.hasNext()) {
            return false;
        }
        while (this.current == null && this.delegate.hasNext()) {
            KeyValue next = (KeyValue)this.delegate.next();
            if (!this.predicate.test(next.key, next.value)) continue;
            this.current = next;
        }
        return this.current != null;
    }

    public KeyValue<K, V> next() {
        if (this.current == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        KeyValue<K, V> result = this.current;
        this.current = null;
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }
}

