/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RetryUtils {
    private static final Random rand = new Random();

    public static <T> ListenableFuture<T> retryWithJitter(final ListeningScheduledExecutorService exec, final AsyncCallable<T> asyncCallable, final int intervalMs) {
        final SettableFuture result = SettableFuture.create();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                final 1 outerThis = this;
                try {
                    Futures.addCallback((ListenableFuture)asyncCallable.call(), (FutureCallback)new FutureCallback<T>(){

                        public void onSuccess(T value) {
                            result.set(value);
                        }

                        public void onFailure(Throwable t) {
                            int jitter = (rand.nextInt(intervalMs * 2) - intervalMs) / 5;
                            exec.schedule(outerThis, (long)(intervalMs + jitter), TimeUnit.MILLISECONDS);
                        }
                    }, (Executor)exec);
                }
                catch (Exception e) {
                    result.setException((Throwable)e);
                }
            }
        };
        exec.submit(task);
        return result;
    }
}

