/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Inject;
import io.confluent.controlcenter.BootstrapClientConfigSupplier;
import io.confluent.controlcenter.BootstrapClientSupplier;
import io.confluent.controlcenter.util.ProxyUtil;
import java.util.Map;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;

public class CachingBootstrapClientSupplier
implements BootstrapClientSupplier,
AutoCloseable {
    private final BootstrapClientConfigSupplier config;
    private final Supplier<Admin> supplier;
    private volatile AdminClient client;

    @Inject
    public CachingBootstrapClientSupplier(BootstrapClientConfigSupplier config) {
        this.config = config;
        this.supplier = Suppliers.memoize(this::createClient);
    }

    private Admin createClient() {
        this.client = AdminClient.create((Map)this.config.get());
        return (Admin)ProxyUtil.newDelegatingProxy(Admin.class, this.client, () -> {});
    }

    @Override
    public Admin get() {
        return (Admin)this.supplier.get();
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

