/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.github.zafarkhaja.semver.Version;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.C3Version;
import io.confluent.controlcenter.BootstrapClientConfigSupplier;
import io.confluent.controlcenter.BootstrapClientSupplier;
import io.confluent.controlcenter.CachingBootstrapClientSupplier;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.FeatureFlags;
import io.confluent.controlcenter.KafkaHelper;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.data.ConsumerOffsetsModule;
import io.confluent.controlcenter.healthcheck.HealthCheckModule;
import io.confluent.controlcenter.ksql.KsqlClusterMetadata;
import io.confluent.controlcenter.rest.CompoundClusterTokenCredential;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.controlcenter.rest.RestModule;
import io.confluent.controlcenter.schemaregistry.CachingSchemaRegistryClientSupplier;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientManager;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientSupplier;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClusterMetadata;
import io.confluent.controlcenter.streams.SingleGroupPartitionGrouper;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.util.TopicInfo;
import io.confluent.rest.RestConfig;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.common.record.TimestampType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlCenterConfigModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(ControlCenterConfigModule.class);
    private final ControlCenterConfig controlCenterConfig;
    private final boolean enableSubTopologies;
    private final ImmutableSet<String> subTopologyTopics;

    public ControlCenterConfigModule(ControlCenterConfig controlCenterConfig) {
        this(controlCenterConfig, false, null);
    }

    public ControlCenterConfigModule(ControlCenterConfig controlCenterConfig, boolean enableSubTopologies, ImmutableSet<String> subTopologyTopics) {
        this.controlCenterConfig = controlCenterConfig;
        this.enableSubTopologies = enableSubTopologies;
        this.subTopologyTopics = subTopologyTopics;
    }

    protected void configure() {
        this.bind(BootstrapClientSupplier.class).to(CachingBootstrapClientSupplier.class).in(Singleton.class);
        this.bind(Key.get(String.class, HealthCheckModule.SessionId.class)).toInstance((Object)UUID.randomUUID().toString());
        if (this.enableSubTopologies) {
            this.requestStaticInjection(new Class[]{SingleGroupPartitionGrouper.class});
        }
    }

    @Provides
    protected ControlCenterConfig provideControlCenterConfig() {
        return this.controlCenterConfig;
    }

    @Provides
    @EnableSubTopologies
    protected boolean areSubTopologiesEnabled() {
        return this.enableSubTopologies;
    }

    @Provides
    @SubTopologyInputTopics
    protected ImmutableSet<String> provideSubTopologyTopics() {
        return this.subTopologyTopics;
    }

    @Provides
    @Inject
    @Singleton
    protected Version provideControlCenterVersion() throws IOException {
        return C3Version.getVersion();
    }

    @Provides
    @HealthCheckModule.PhoneHomeEnabled
    @Inject
    protected boolean getPhoneHomeEnabled(ControlCenterConfig config) {
        return config.getBoolean("confluent.support.metrics.enable");
    }

    @Provides
    @HealthCheckModule.PhoneHomeCustomerId
    @Inject
    protected String getPhoneHomeCustomerId(ControlCenterConfig config) {
        return config.getString("confluent.support.metrics.customer.id");
    }

    @Provides
    @HealthCheckModule.SegmentId
    @Inject
    protected String getPhoneHomeSegmentId(ControlCenterConfig config) {
        return config.getString("confluent.support.metrics.segment.id");
    }

    @Provides
    @HealthCheckModule.ControlCenterInstance
    @Inject
    @Singleton
    protected String getControlCenterInstance(ControlCenterConfig config) {
        return Hashing.sha256().newHasher().putString((CharSequence)Joiner.on((char)'\u00ff').join((Object)config.getString("confluent.controlcenter.id"), (Object)config.getString("confluent.controlcenter.command.topic"), new Object[]{config.getString("confluent.metrics.topic"), config.getString("confluent.monitoring.interceptor.topic")}), Charsets.UTF_8).hash().toString();
    }

    @Provides
    @ControlCenterRestModule.DisplayHost
    @Inject
    protected String getDisplayHost(ControlCenterConfig config) {
        return config.getString("confluent.controlcenter.rest.advertised.url");
    }

    @Provides
    @ConsumerOffsetsModule.ConsumerMetadataTimeout
    @Inject
    protected int getConsumerMetadataTimeout(ControlCenterConfig config) {
        return config.getInt("confluent.controlcenter.consumer.metadata.timeout.ms");
    }

    @Provides
    @Inject
    protected RestConfig getRestConfig(ControlCenterConfig config, ControlCenterRbacConfig rbacConfig) {
        HashMap props = Maps.newHashMap();
        props.putAll(config.valuesWithPrefix("confluent.controlcenter.rest."));
        props.putAll(config.originalsWithPrefix("confluent.controlcenter.rest."));
        if (rbacConfig.isRbacEnabled()) {
            props.put("authentication.roles", ImmutableList.of((Object)"**"));
        }
        return new RestConfig(RestConfig.baseConfigDef(), (Map)props);
    }

    @Provides
    @Inject
    @Singleton
    protected ControlCenterRbacConfig getRbacConfig(ControlCenterConfig controlCenterConfig) {
        return ControlCenterRbacConfig.fromControlCenterConfig(controlCenterConfig);
    }

    @Provides
    @Singleton
    @Inject
    BootstrapClientConfigSupplier adminClientConfig(ControlCenterConfig controlCenterConfig, ControlCenterRbacConfig rbacConfig) {
        final HashMap config = Maps.newHashMap();
        config.put("bootstrap.servers", controlCenterConfig.getList("bootstrap.servers"));
        rbacConfig.putAllIfAbsentRbacControlCenterConfigs(config);
        config.putAll(controlCenterConfig.valuesWithPrefix("confluent.controlcenter.streams."));
        config.putAll(controlCenterConfig.originalsWithPrefix("confluent.controlcenter.streams."));
        return new BootstrapClientConfigSupplier(){

            @Override
            public Map<String, Object> get() {
                return config;
            }
        };
    }

    @Provides
    @Inject
    @RestModule.BrokerConfigsEditEnabled
    boolean brokerConfigsEditEnabled(ControlCenterConfig config) {
        return config.getBoolean("confluent.controlcenter.broker.config.edit.enable");
    }

    @Provides
    @Inject
    @Singleton
    @ControlCenterRestModule.KafkaClusterConfigSupplier
    StaticClusterConfigSupplier provideKafkaClusterConfigSupplier(ControlCenterConfig config) {
        return new StaticClusterConfigSupplier(config, "confluent.controlcenter.kafka.");
    }

    @Provides
    @Inject
    @Singleton
    @ControlCenterRestModule.ConnectClusterConfigSupplier
    StaticClusterConfigSupplier provideConnectClusterConfigSupplier(ControlCenterConfig config) {
        return new StaticClusterConfigSupplier(config, "confluent.controlcenter.connect.");
    }

    @Provides
    @Inject
    @Singleton
    @ControlCenterRestModule.KsqlClusterConfigSupplier
    StaticClusterConfigSupplier provideKsqlClusterConfigSupplier(ControlCenterConfig config) {
        return new StaticClusterConfigSupplier(config, "confluent.controlcenter.ksql.");
    }

    @Provides
    @Inject
    @Singleton
    protected KsqlClusterMetadata provideKsqlMetadata(@ControlCenterRestModule.KsqlClusterConfigSupplier StaticClusterConfigSupplier staticKsqlClusterConfigSupplier, ControlCenterConfig config) {
        return new KsqlClusterMetadata(staticKsqlClusterConfigSupplier, config);
    }

    @Provides
    @Singleton
    @Inject
    @RestModule.SchemaRegistry
    List<String> getSchemaRegistryEndpoints(ControlCenterConfig config) {
        return config.getList("confluent.controlcenter.schema.registry.url");
    }

    @Provides
    @Inject
    @Singleton
    @ControlCenterRestModule.SchemaRegistryClusterConfigSupplier
    StaticClusterConfigSupplier provideSchemaRegistryClusterConfigSupplier(ControlCenterConfig config) {
        return new StaticClusterConfigSupplier(config, "confluent.controlcenter.schema.registry.");
    }

    @Provides
    @Singleton
    @Inject
    @RestModule.SchemaRegistry
    Map<String, Object> schemaRegistryClientConfig(ControlCenterConfig controlCenterConfig) {
        HashMap config = Maps.newHashMap();
        config.putAll(controlCenterConfig.originalsWithPrefix("confluent.controlcenter.schema.registry."));
        return config;
    }

    @Provides
    @Singleton
    @Inject
    SchemaRegistryClientManager getSchemaRegistryClientManager(SchemaRegistryClusterMetadata srClusterMetadata, ControlCenterRbacConfig rbacConfig) {
        return new SchemaRegistryClientManager(srClusterMetadata, rbacConfig);
    }

    @Provides
    @Singleton
    @Inject
    SchemaRegistryClientSupplier<CompoundClusterTokenCredential> getSchemaRegistryClientSupplier(SchemaRegistryClientManager schemaRegistryClientManager) {
        return new CachingSchemaRegistryClientSupplier<CompoundClusterTokenCredential>(schemaRegistryClientManager);
    }

    @Provides
    @ControlTopics
    @Inject
    protected Set<TopicInfo> getControlTopics(ControlCenterConfig config, TopicStoreMaster topicStoreMaster) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int internalPartitions = config.getInt("confluent.controlcenter.internal.topics.partitions");
        short internalReplication = config.getShort("confluent.controlcenter.internal.topics.replication");
        long internalRetentionMs = config.getLong("confluent.controlcenter.internal.topics.retention.ms");
        long internalRetentionBytes = config.getLong("confluent.controlcenter.internal.topics.retention.bytes");
        long internalChangelogSegmentBytes = config.getLong("confluent.controlcenter.internal.topics.changelog.segment.bytes");
        log.info("getPersistentStoreTopicNames={}", topicStoreMaster.getPersistentStoreTopicNames());
        for (String name : topicStoreMaster.getPersistentStoreTopicNames()) {
            builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setReplication(internalReplication).setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName(name).setCompact().setSegmentBytes(internalChangelogSegmentBytes).setDeleteRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).setRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).build());
        }
        log.info("getLruStoreTopicNames={}", topicStoreMaster.getLruStoreTopicNames());
        for (String name : topicStoreMaster.getLruStoreTopicNames()) {
            builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setReplication(internalReplication).setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName(name).setCompact().setSegmentBytes(internalChangelogSegmentBytes / 2L).setDeleteRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).setRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).build());
        }
        log.info("getWindowedStoreTopicNames={}", topicStoreMaster.getWindowedStoreTopicNames());
        for (String name : topicStoreMaster.getWindowedStoreTopicNames()) {
            builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setReplication(internalReplication).setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName(name).setCompactDelete().setSegmentBytes(internalChangelogSegmentBytes).setDeleteRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).setRetentionMs(KafkaHelper.compactedTopicRetention(name, internalRetentionMs)).build());
        }
        log.info("getLogAppendTimeIntermediateTopicNames={}", topicStoreMaster.getLogAppendTimeIntermediateTopicNames());
        for (String name : topicStoreMaster.getLogAppendTimeIntermediateTopicNames()) {
            builder.add((Object)TopicInfo.builder().setPartitions(internalPartitions).setReplication(internalReplication).setDelete().setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName(name).addConfigEntry("message.timestamp.type", TimestampType.LOG_APPEND_TIME.name).build());
        }
        Sets.SetView intermediateTopics = Sets.difference(topicStoreMaster.getIntermediateTopicNames(), topicStoreMaster.getLogAppendTimeIntermediateTopicNames());
        log.info("intermediateTopics={}", (Object)intermediateTopics);
        for (String name : intermediateTopics) {
            builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setReplication(internalReplication).setDelete().setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName(name).build());
        }
        builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setName(config.getString("confluent.controlcenter.command.topic")).setPartitions(1).setReplication(config.getShort("confluent.controlcenter.command.topic.replication")).setDeleteRetentionMs(config.getLong("confluent.controlcenter.command.topic.retention.ms")).setSegmentBytes(config.getLong("confluent.controlcenter.internal.topics.changelog.segment.bytes")).setCompact().build());
        builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).setName(config.getString("confluent.monitoring.interceptor.topic")).setPartitions(config.getInt("confluent.monitoring.interceptor.topic.partitions")).setReplication(config.getShort("confluent.monitoring.interceptor.topic.replication")).setDelete().setRetentionMs(config.getLong("confluent.monitoring.interceptor.topic.retention.ms")).setRetentionBytes(config.getLong("confluent.monitoring.interceptor.topic.retention.bytes")).addConfigEntry("message.timestamp.type", TimestampType.LOG_APPEND_TIME.name).setValidateConfig(config.getBoolean("confluent.monitoring.interceptor.topic.config.validate")).build());
        builder.add((Object)TopicInfo.builder().addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setName(config.getString("confluent.metrics.topic")).setPartitions(config.getInt("confluent.metrics.topic.partitions")).setDelete().setReplication(config.getShort("confluent.metrics.topic.replication")).setRetentionMs(config.getLong("confluent.metrics.topic.retention.ms")).setRetentionBytes(config.getLong("confluent.metrics.topic.retention.bytes")).addConfigEntry("max.message.bytes", config.getInt("confluent.metrics.topic.max.message.bytes")).setValidateConfig(config.getBoolean("confluent.metrics.topic.config.validate")).build());
        return builder.build();
    }

    @Provides
    @ServiceHealthCheckInterval
    public Duration getHealthCheckInterval() {
        return Duration.ofSeconds(this.controlCenterConfig.getInt("confluent.controlcenter.service.healthcheck.interval.sec").intValue());
    }

    @Provides
    @Inject
    public FeatureFlags getFeaturFlags(ControlCenterRbacConfig rbacConfig, ControlCenterConfig config) {
        return new FeatureFlags(config.getBoolean("confluent.controlcenter.ksql.enable"), config.getBoolean("confluent.controlcenter.schema.registry.enable"), config.getBoolean("confluent.controlcenter.topic.inspection.enable"), config.getBoolean("confluent.controlcenter.broker.config.edit.enable"), config.getBoolean("confluent.controlcenter.license.manager.enable"), rbacConfig.isRbacEnabled(), config.getBoolean("confluent.controlcenter.consumers.view.enable"), config.getBoolean("confluent.controlcenter.deprecated.views.enable"), config.getInt("confluent.controlcenter.ui.data.expired.threshold"), config.getBoolean("confluent.controlcenter.ui.autoupdate.enable"), config.getBoolean("confluent.controlcenter.usage.data.collection.enable"), config.getBoolean("confluent.controlcenter.proactive.support.ui.cta.enable"), config.getBoolean("confluent.controlcenter.ui.replicator.monitoring.enable"), config.getBoolean("confluent.controlcenter.sbk.ui.enable"), config.getBoolean("confluent.controlcenter.ui.controller.chart.enable"), config.getBoolean("confluent.controlcenter.trigger.active-controller-count.enable"), config.getBoolean("confluent.controlcenter.rest.csrf.prevention.enable"), config.getInt("confluent.controlcenter.rest.csrf.prevention.token.expiration.minutes"), config.getString("confluent.controlcenter.rest.csrf.prevention.token.endpoint"));
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ServiceHealthCheckInterval {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ControlTopics {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SubTopologyInputTopics {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface EnableSubTopologies {
    }
}

