/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.confluent.command.CommandStore;
import io.confluent.command.CommandUtil;
import io.confluent.command.record.Command;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.alert.AlertSenderRouter;
import io.confluent.controlcenter.alert.AlertUtil;
import io.confluent.controlcenter.alert.TriggerEventUtil;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.command.CommandModule;
import io.confluent.controlcenter.data.ConsumerOffsetsModule;
import io.confluent.controlcenter.healthcheck.HealthCheckModule;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.rest.res.ConsumerGroupOffsets;
import io.confluent.monitoring.common.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertManager
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AlertManager.class);
    private static final long COMMAND_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final Command.CommandKey CLUSTER_DOWN_TRIGGER_CMD_KEY = CommandUtil.createCommandKey((String)"control-center-cluster-down-trigger", (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG);
    private static final String CLUSTER_DOWN_TRIGGER_NAME = "Cluster down";
    private static final Command.CommandKey CLUSTER_DOWN_ACTION_EMAIL_CMD_KEY = CommandUtil.createCommandKey((String)"control-center-cluster-down-action-email", (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG);
    private static final Command.CommandKey CLUSTER_DOWN_ACTION_WEBHOOK_SLACK_CMD_KEY = CommandUtil.createCommandKey((String)"control-center-cluster-down-action-webhook-slack", (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG);
    private static final Command.CommandKey CLUSTER_DOWN_ACTION_WEBHOOK_PAGERDUTY_CMD_KEY = CommandUtil.createCommandKey((String)"control-center-cluster-down-action-webhook-pagerduty", (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG);
    private static final String CLUSTER_DOWN_ACTION_EMAIL_NAME = "Cluster down email alert";
    private static final String CLUSTER_DOWN_ACTION_SLACK_NAME = "Cluster down slack alert";
    private static final String CLUSTER_DOWN_ACTION_PAGERDUTY_NAME = "Cluster down pagerduty alert";
    private final ControlCenterConfig config;
    private final CommandStore commandStore;
    private final Provider<? extends ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> triggerConfigsProvider;
    private final Provider<? extends ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> actionConfigsProvider;
    private final Map<Controlcenter.TriggerEventKey, Controlcenter.TriggerActions> triggerActionsMap = new ConcurrentHashMap<Controlcenter.TriggerEventKey, Controlcenter.TriggerActions>();
    private final AlertSenderRouter sender;
    private final Clock clock;
    private final Map<String, Map<CommandAlert.BrokerTriggerMetricType, Controlcenter.TriggerMeasurement>> clusterStatusData;
    private final Map<String, Map<String, ConsumerGroupOffsets>> consumerOffsetData;
    private Map<Command.CommandKey, KeyValue<Command.CommandKey, Command.CommandMessage>> triggerConfigs = new HashMap<Command.CommandKey, KeyValue<Command.CommandKey, Command.CommandMessage>>();
    private Map<Command.CommandKey, KeyValue<Command.CommandKey, Command.CommandMessage>> actionConfigs = new HashMap<Command.CommandKey, KeyValue<Command.CommandKey, Command.CommandMessage>>();

    @Inject
    public AlertManager(ControlCenterConfig config, CommandStore commandStore, @CommandModule.TriggerConfigs Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> triggerConfigsProvider, @CommandModule.ActionConfigs Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> actionConfigsProvider, Clock clock, AlertSenderRouter sender, @HealthCheckModule.ClusterStatus Map<String, Map<CommandAlert.BrokerTriggerMetricType, Controlcenter.TriggerMeasurement>> clusterStatusData, @ConsumerOffsetsModule.ConsumerOffsets Map<String, Map<String, ConsumerGroupOffsets>> consumerOffsetData) {
        this.config = config;
        this.commandStore = commandStore;
        this.triggerConfigsProvider = triggerConfigsProvider;
        this.actionConfigsProvider = actionConfigsProvider;
        this.clock = clock;
        this.sender = sender;
        this.clusterStatusData = clusterStatusData;
        this.consumerOffsetData = consumerOffsetData;
    }

    @Override
    public void run() {
        try {
            this.loadTriggerActionConfigs();
            this.checkClusterStatus();
            this.checkConsumerLag();
        }
        catch (Throwable t) {
            log.warn("alert manager failed", t);
        }
    }

    Map<Controlcenter.TriggerEventKey, Controlcenter.TriggerActions> getTriggerActionsState() {
        return ImmutableMap.copyOf(this.triggerActionsMap);
    }

    void checkClusterStatus() {
        for (Map.Entry<String, Map<CommandAlert.BrokerTriggerMetricType, Controlcenter.TriggerMeasurement>> statusMap : this.clusterStatusData.entrySet()) {
            for (Controlcenter.TriggerMeasurement measurement : statusMap.getValue().values()) {
                try {
                    this.checkAndMaybeSendAlert(measurement);
                }
                catch (Throwable t) {
                    log.warn("unable to check status and send alerts for clusterId={} measurement={}", new Object[]{statusMap.getKey(), measurement, t});
                }
            }
        }
    }

    void checkConsumerLag() {
        for (Map.Entry<String, Map<String, ConsumerGroupOffsets>> cgOffsetsEntry : this.consumerOffsetData.entrySet()) {
            String clusterId = cgOffsetsEntry.getKey();
            for (ConsumerGroupOffsets cgOffsets : cgOffsetsEntry.getValue().values()) {
                try {
                    this.checkAndMaybeSendAlert(this.buildConsumerLagMeasurement(clusterId, cgOffsets));
                    this.checkAndMaybeSendAlert(this.buildConsumerLeadMeasurement(clusterId, cgOffsets));
                }
                catch (Throwable t) {
                    log.warn("unable to check consumer offsets for clusterId={} consumerGroupId={}", new Object[]{clusterId, cgOffsets.getConsumerGroupId(), t});
                }
            }
        }
    }

    Controlcenter.TriggerMeasurement buildConsumerLagMeasurement(String clusterId, ConsumerGroupOffsets offsets) {
        Controlcenter.ClientTriggerMeasurement measurement = Controlcenter.ClientTriggerMeasurement.newBuilder().setConsumerLag(offsets.getTotalLag()).build();
        return Controlcenter.TriggerMeasurement.newBuilder().setClusterId(clusterId).setComponent(offsets.getConsumerGroupId()).setComponentType(Controlcenter.ComponentType.CONSUMER_GROUP).setClientMeasurement(measurement).setArrivalTime(this.clock.currentTimeMillis()).build();
    }

    Controlcenter.TriggerMeasurement buildConsumerLeadMeasurement(String clusterId, ConsumerGroupOffsets offsets) {
        Controlcenter.ClientTriggerMeasurement measurement = Controlcenter.ClientTriggerMeasurement.newBuilder().setConsumerLead(offsets.getTotalLead()).build();
        return Controlcenter.TriggerMeasurement.newBuilder().setClusterId(clusterId).setComponent(offsets.getConsumerGroupId()).setComponentType(Controlcenter.ComponentType.CONSUMER_GROUP).setClientMeasurement(measurement).setArrivalTime(this.clock.currentTimeMillis()).build();
    }

    void checkAndMaybeSendAlert(Controlcenter.TriggerMeasurement measurement) {
        if (measurement == null) {
            log.warn("TriggerMeasurement is null");
            return;
        }
        long now = this.clock.currentTimeMillis();
        ArrayList<KeyValue<Bytes, Controlcenter.TriggerEvent>> triggerList = new ArrayList<KeyValue<Bytes, Controlcenter.TriggerEvent>>();
        TriggerEventUtil.createTriggerEventsIfTriggerable(measurement, triggerList, now, this.triggerConfigs.values());
        log.trace("triggerList={}", triggerList);
        for (KeyValue keyValue : triggerList) {
            Controlcenter.TriggerEvent triggerEvent = (Controlcenter.TriggerEvent)keyValue.value;
            KeyValue<Command.CommandKey, Command.CommandMessage> trigConfigKv = this.triggerConfigs.get(Command.CommandKey.newBuilder().setGuid(triggerEvent.getTriggerGuid()).setConfigType(Command.CommandConfigType.MONITORING_TRIGGER_CONFIG).build());
            if (trigConfigKv == null) continue;
            Controlcenter.TriggerEventKey triggerEventKey = Controlcenter.TriggerEventKey.newBuilder().setTriggerGuid(triggerEvent.getTriggerGuid()).setComponent(AlertUtil.getComponentForKey(triggerEvent.getInfo().getComponent())).build();
            Controlcenter.TriggerActions storedActions = this.triggerActionsMap.get(triggerEventKey);
            Controlcenter.TriggerActions modifiedActions = AlertUtil.updateTriggerActionsFromConfig(triggerEvent.getTriggerGuid(), triggerEvent.getInfo().getComponent(), storedActions, (Command.CommandMessage)trigConfigKv.value, this.actionConfigs.values());
            if (modifiedActions == null) {
                if (storedActions == null) continue;
                log.debug("Removing trigger actions actions={}", (Object)storedActions);
                this.triggerActionsMap.remove(triggerEventKey);
                continue;
            }
            Controlcenter.TriggerActions.Builder actionsBuilder = Controlcenter.TriggerActions.newBuilder((Controlcenter.TriggerActions)modifiedActions);
            for (int i = 0; i < modifiedActions.getActionsCount(); ++i) {
                Controlcenter.TriggerAction action = modifiedActions.getActions(i);
                if (now < action.getNextActionTimestamp()) continue;
                CommandAlert.MonitoringTriggerConfig monitoringTriggerConfig = ((Command.CommandMessage)trigConfigKv.value).getMonitoringTriggerConfig();
                if (!monitoringTriggerConfig.getGuid().equals(modifiedActions.getTriggerGuid())) {
                    log.warn("mismatching guids action={} trigger={}", (Object)modifiedActions.getTriggerGuid(), (Object)monitoringTriggerConfig.getGuid());
                    continue;
                }
                Alert.AlertInfo.Builder alertBuilder = Alert.AlertInfo.newBuilder().setGuid(UUID.randomUUID().toString()).setTimestamp(now).setMonitoringTrigger(monitoringTriggerConfig).addAllActions((Iterable)action.getActionsList()).addAllTriggers((Iterable)ImmutableList.of((Object)triggerEvent.getInfo()));
                long nextActionTimestamp = AlertUtil.computeNextActionTimestamp(action, now);
                actionsBuilder.setActions(i, action.toBuilder().setNextActionTimestamp(nextActionTimestamp));
                this.sender.sendWithoutHistory(alertBuilder.build());
            }
            Controlcenter.TriggerActions newActions = actionsBuilder.build();
            if (modifiedActions.equals((Object)newActions)) continue;
            log.debug("Storing trigger actions triggerEventKey={}, actions={}", (Object)triggerEventKey, (Object)newActions);
            this.triggerActionsMap.put(triggerEventKey, newActions);
        }
    }

    void loadTriggerActionConfigs() {
        try {
            this.triggerConfigs = this.getAndMapCommands(this.triggerConfigsProvider);
            this.actionConfigs = this.getAndMapCommands(this.actionConfigsProvider);
        }
        catch (Exception e) {
            log.debug("Failed to load trigger/action from command store, keeping extant configs", (Throwable)e);
        }
    }

    Map<Command.CommandKey, KeyValue<Command.CommandKey, Command.CommandMessage>> getAndMapCommands(Provider<? extends ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> provider) {
        HashMap<Command.CommandKey, KeyValue<Command.CommandKey, Command.CommandMessage>> ret = new HashMap<Command.CommandKey, KeyValue<Command.CommandKey, Command.CommandMessage>>();
        try (KeyValueIterator i = ((ReadOnlyKeyValueStore)provider.get()).all();){
            while (i.hasNext()) {
                KeyValue message = (KeyValue)i.next();
                ret.put((Command.CommandKey)message.key, this.overrideCommandFields((KeyValue<Command.CommandKey, Command.CommandMessage>)message));
            }
        }
        return ret;
    }

    KeyValue<Command.CommandKey, Command.CommandMessage> overrideCommandFields(KeyValue<Command.CommandKey, Command.CommandMessage> kv) {
        Command.CommandMessage message = (Command.CommandMessage)kv.value;
        if (message.hasMonitoringTriggerConfig() && message.getMonitoringTriggerConfig().getMetric() == CommandAlert.TriggerMetricType.CONSUMER_LAG) {
            CommandAlert.MonitoringTriggerConfig triggerConfig = CommandAlert.MonitoringTriggerConfig.newBuilder((CommandAlert.MonitoringTriggerConfig)((Command.CommandMessage)kv.value).getMonitoringTriggerConfig()).setLagMs(0L).build();
            Command.CommandMessage newMessage = Command.CommandMessage.newBuilder((Command.CommandMessage)((Command.CommandMessage)kv.value)).setMonitoringTriggerConfig(triggerConfig).build();
            return new KeyValue(kv.key, (Object)newMessage);
        }
        return kv;
    }

    public void autoCreateClusterDownTriggerAndAction(String clusterId) {
        if (clusterId == null) {
            log.warn("could not auto create cluster down trigger and action, unable to get local clusterId");
            return;
        }
        this.addClusterDownTrigger(clusterId);
        this.addClusterDownAction();
    }

    void addClusterDownTrigger(String clusterId) {
        if (this.triggerConfigs.containsKey(CLUSTER_DOWN_TRIGGER_CMD_KEY)) {
            return;
        }
        CommandAlert.MonitoringTriggerConfig triggerConfig = CommandAlert.MonitoringTriggerConfig.newBuilder().setGuid(CLUSTER_DOWN_TRIGGER_CMD_KEY.getGuid()).setName(CLUSTER_DOWN_TRIGGER_NAME).setBrokerClusters(CommandAlert.BrokerClusterComponents.newBuilder().addAllBrokerClusters((Iterable)ImmutableList.of((Object)clusterId)).build()).setBrokerMetric(CommandAlert.BrokerTriggerMetricType.CLUSTER_STATUS).setCondition(CommandAlert.TriggerCondition.EQUAL).setStatusValue(CommandAlert.StatusValue.OFFLINE).build();
        Command.CommandKey trigCommandKey = CommandUtil.createCommandKey((String)triggerConfig.getGuid(), (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG);
        Command.CommandMessage trigCommandMessage = Command.CommandMessage.newBuilder().setMonitoringTriggerConfig(triggerConfig).build();
        try {
            this.commandStore.awaitCommand(trigCommandKey, trigCommandMessage, COMMAND_TIMEOUT);
        }
        catch (Exception e) {
            log.debug("Fail to create cluster down trigger");
        }
        this.triggerConfigs.put(trigCommandKey, (KeyValue<Command.CommandKey, Command.CommandMessage>)KeyValue.pair((Object)trigCommandKey, (Object)trigCommandMessage));
    }

    void addClusterDownAction() {
        if (!this.actionConfigs.containsKey(CLUSTER_DOWN_ACTION_EMAIL_CMD_KEY) && !this.config.getString("confluent.controlcenter.alert.cluster.down.to.email").isEmpty()) {
            CommandAlert.ActionConfig emailActionConfig = CommandAlert.ActionConfig.newBuilder().setGuid(CLUSTER_DOWN_ACTION_EMAIL_CMD_KEY.getGuid()).setName(CLUSTER_DOWN_ACTION_EMAIL_NAME).setEnabled(true).addTriggerGuid(CLUSTER_DOWN_TRIGGER_CMD_KEY.getGuid()).setMaxSendRate(this.config.getInt("confluent.controlcenter.alert.cluster.down.send.rate").intValue()).setIntervalMs(TimeUnit.HOURS.toMillis(1L)).setEmail(CommandAlert.EmailAction.newBuilder().setSubject("Confluent Control Center cluster down!").setAddress(this.config.getString("confluent.controlcenter.alert.cluster.down.to.email")).build()).build();
            this.sendActionToCommandStore(emailActionConfig);
        }
        if (!this.actionConfigs.containsKey(CLUSTER_DOWN_ACTION_WEBHOOK_SLACK_CMD_KEY) && !this.config.getString("confluent.controlcenter.alert.cluster.down.to.webhookurl.slack").isEmpty()) {
            CommandAlert.ActionConfig slackActionConfig = CommandAlert.ActionConfig.newBuilder().setGuid(CLUSTER_DOWN_ACTION_WEBHOOK_SLACK_CMD_KEY.getGuid()).setName(CLUSTER_DOWN_ACTION_SLACK_NAME).setEnabled(true).addTriggerGuid(CLUSTER_DOWN_TRIGGER_CMD_KEY.getGuid()).setMaxSendRate(this.config.getInt("confluent.controlcenter.alert.cluster.down.send.rate").intValue()).setIntervalMs(TimeUnit.HOURS.toMillis(1L)).setWebhook(CommandAlert.WebHookAction.newBuilder().setSubject("Confluent Control Center cluster down!").setUrl(this.config.getString("confluent.controlcenter.alert.cluster.down.to.webhookurl.slack")).setSlack(CommandAlert.Slack.newBuilder().build())).build();
            this.sendActionToCommandStore(slackActionConfig);
        }
        if (!this.actionConfigs.containsKey(CLUSTER_DOWN_ACTION_WEBHOOK_PAGERDUTY_CMD_KEY) && !this.config.getString("confluent.controlcenter.alert.cluster.down.to.pagerduty.integrationkey").isEmpty()) {
            CommandAlert.ActionConfig pagerdutyActionConfig = CommandAlert.ActionConfig.newBuilder().setGuid(CLUSTER_DOWN_ACTION_WEBHOOK_PAGERDUTY_CMD_KEY.getGuid()).setName(CLUSTER_DOWN_ACTION_PAGERDUTY_NAME).setEnabled(true).addTriggerGuid(CLUSTER_DOWN_TRIGGER_CMD_KEY.getGuid()).setMaxSendRate(this.config.getInt("confluent.controlcenter.alert.cluster.down.send.rate").intValue()).setIntervalMs(TimeUnit.HOURS.toMillis(1L)).setWebhook(CommandAlert.WebHookAction.newBuilder().setSubject("Confluent Control Center cluster down!").setUrl("https://events.pagerduty.com/v2/enqueue").setPagerduty(CommandAlert.PagerDuty.newBuilder().setRoutingKey(this.config.getString("confluent.controlcenter.alert.cluster.down.to.pagerduty.integrationkey")).setEventAction("trigger").setPayload(CommandAlert.PagerDutyPayload.newBuilder().setSummary("Confluent Control Center cluster down!").setSeverity(CommandAlert.PagerDutySeverity.critical).build()).build())).build();
            this.sendActionToCommandStore(pagerdutyActionConfig);
        }
    }

    void sendActionToCommandStore(CommandAlert.ActionConfig actionConfig) {
        Command.CommandKey actionCommandKey = CommandUtil.createCommandKey((String)actionConfig.getGuid(), (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG);
        Command.CommandMessage actionCommandMessage = Command.CommandMessage.newBuilder().setActionConfig(actionConfig).build();
        try {
            this.commandStore.awaitCommand(actionCommandKey, actionCommandMessage, COMMAND_TIMEOUT);
        }
        catch (Exception e) {
            log.debug("Fail to create cluster down action");
        }
        this.actionConfigs.put(actionCommandKey, (KeyValue<Command.CommandKey, Command.CommandMessage>)KeyValue.pair((Object)actionCommandKey, (Object)actionCommandMessage));
    }
}

