/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import com.google.protobuf.Message;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.alert.AlertSender;
import io.confluent.controlcenter.alert.AlertUtil;
import io.confluent.controlcenter.alert.WebhookSender;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.serializers.ProtoSerde;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackWebhookSender
extends WebhookSender {
    private static final Logger log = LoggerFactory.getLogger(SlackWebhookSender.class);

    public SlackWebhookSender(Alert.AlertInfo info, CommandAlert.WebHookAction webHookAction, boolean linkToHistory, AlertSender alertSender) {
        super(info, webHookAction, linkToHistory, alertSender);
        CommandAlert.Slack slack = CommandAlert.Slack.newBuilder().setText(AlertUtil.getAlertContent(info, alertSender, linkToHistory)).mergeFrom(webHookAction.getSlack()).build();
        this.webHookAction = CommandAlert.WebHookAction.newBuilder((CommandAlert.WebHookAction)webHookAction).setSlack(slack).mergeFrom(this.webHookAction).build();
    }

    @Override
    void setHeader(HttpPost httpPost) {
    }

    @Override
    public String constructPayloadFormat() {
        ProtoSerde slackProtoSerde = new ProtoSerde((Message)CommandAlert.Slack.getDefaultInstance());
        String content = slackProtoSerde.toJson((Message)this.webHookAction.getSlack(), true);
        return content;
    }
}

