/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import com.google.common.base.Preconditions;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.alert.AlertSender;
import io.confluent.controlcenter.alert.record.Alert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebhookSender {
    Alert.AlertInfo info;
    CommandAlert.WebHookAction webHookAction;
    boolean linkToHistory;
    AlertSender alertSender;
    private static final Logger log = LoggerFactory.getLogger(WebhookSender.class);

    public WebhookSender(Alert.AlertInfo info, CommandAlert.WebHookAction webHookAction, boolean linkToHistory, AlertSender alertSender) {
        this.info = info;
        this.webHookAction = webHookAction;
        this.linkToHistory = linkToHistory;
        this.alertSender = alertSender;
    }

    public HttpResponse sendWebHook() {
        HttpResponse rawResponse = null;
        try {
            Preconditions.checkNotNull((Object)this.webHookAction, (Object)"WebHookAction is null. Cannot send a webhook alert.");
            Preconditions.checkNotNull((Object)this.webHookAction.getUrl(), (Object)"URL for WebHookAction is null. Cannot send a webhook alert.");
            HttpPost httppost = new HttpPost(this.webHookAction.getUrl());
            String payload = this.constructPayloadFormat();
            StringEntity requestEntity = new StringEntity(payload, ContentType.APPLICATION_JSON);
            httppost.setEntity((HttpEntity)requestEntity);
            this.setHeader(httppost);
            CloseableHttpClient httpclient = HttpClients.createDefault();
            rawResponse = httpclient.execute((HttpUriRequest)httppost);
        }
        catch (Exception e) {
            log.warn("sending=failure webhook to={} with subject={} from trigger={} {}", new Object[]{this.webHookAction.getUrl(), this.webHookAction.getSubject(), this.info.getMonitoringTrigger().getGuid(), e});
        }
        return rawResponse;
    }

    abstract void setHeader(HttpPost var1);

    abstract String constructPayloadFormat();
}

