/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.connect;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.controlcenter.rest.res.ConnectCluster;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConnectClusterManager {
    public static final String DEFAULT_CONNECT_NAME = "connect-default";
    private static final Logger log = LoggerFactory.getLogger(ConnectClusterManager.class);
    private final Map<String, ConnectCluster> clusterLookup = new ConcurrentHashMap<String, ConnectCluster>();

    @Inject
    public ConnectClusterManager(@ControlCenterRestModule.ConnectClusterConfigSupplier StaticClusterConfigSupplier connectClusterConfigSupplier, ControlCenterConfig config) {
        if (config.getList("confluent.controlcenter.connect.cluster").size() > 0) {
            this.deprecatedInitialize(config);
        } else {
            Set<Map.Entry<String, Map<String, Object>>> configurations = connectClusterConfigSupplier.getConfigurations().entrySet();
            for (Map.Entry<String, Map<String, Object>> entry : configurations) {
                this.addCluster(entry.getKey(), entry.getValue());
            }
        }
    }

    public List<ConnectCluster> getConnectClusters() {
        return this.clusterLookup.entrySet().stream().map(entry -> (ConnectCluster)entry.getValue()).collect(Collectors.toList());
    }

    public ConnectCluster getConnectCluster(String connectClusterName) {
        return this.clusterLookup.get(connectClusterName);
    }

    private void deprecatedInitialize(ControlCenterConfig config) {
        List urls = config.getList("confluent.controlcenter.connect.cluster");
        this.addCluster(DEFAULT_CONNECT_NAME, urls);
    }

    private void addCluster(String name, Map<String, Object> cluster) {
        List<String> urls = ConfigUtils.getList(cluster, "cluster");
        if (urls == null) {
            log.warn("Invalid cluster url property for connect cluster '{}'", (Object)name);
            return;
        }
        this.addCluster(name, urls);
    }

    private void addCluster(String name, List<String> urls) {
        this.clusterLookup.put(name, new ConnectCluster(name, urls));
    }
}

