/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.confluent.controlcenter.BootstrapClientConfigSupplier;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.kafka.KafkaRestManager;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import java.util.Map;
import java.util.concurrent.Callable;

public class ClusterMetadataInitializer
implements Callable<Void> {
    static final String DEFAULT_CLUSTER_KEY = "controlcenter.cluster";
    private final BootstrapClientConfigSupplier bootstrapClientConfigSupplier;
    private final ClusterManager clusterManager;
    private final StaticClusterConfigSupplier kafkaClusterConfigSupplier;
    private String bootstrapClusterId;
    private final KafkaRestManager kafkaRestManager;

    @Inject
    public ClusterMetadataInitializer(BootstrapClientConfigSupplier bootstrapClientConfigSupplier, @ControlCenterRestModule.KafkaClusterConfigSupplier StaticClusterConfigSupplier kafkaClusterConfigSupplier, ClusterManager clusterManager, KafkaRestManager kafkaRestManager) {
        this.bootstrapClientConfigSupplier = bootstrapClientConfigSupplier;
        this.clusterManager = clusterManager;
        this.kafkaClusterConfigSupplier = kafkaClusterConfigSupplier;
        this.kafkaRestManager = kafkaRestManager;
    }

    @Override
    public Void call() throws Exception {
        Object bootstrapClusterConfig = this.bootstrapClientConfigSupplier.get();
        this.bootstrapClusterId = this.clusterManager.register(DEFAULT_CLUSTER_KEY, (Map<String, Object>)bootstrapClusterConfig);
        this.kafkaRestManager.registerCluster(this.bootstrapClusterId, (Map<String, Object>)bootstrapClusterConfig);
        for (Map.Entry<String, Map<String, Object>> entry : this.kafkaClusterConfigSupplier.getConfigurations().entrySet()) {
            ListenableFuture<String> clusterIdFuture = this.clusterManager.addConfiguration(entry.getKey(), entry.getValue());
            this.kafkaRestManager.registerCluster(clusterIdFuture, entry.getKey(), entry.getValue());
        }
        return null;
    }

    public String getBootstrapClusterId() {
        return this.bootstrapClusterId;
    }
}

