/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.inject.Inject;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.ConsumerOffsetsDao;
import io.confluent.controlcenter.data.ConsumerOffsetsModule;
import io.confluent.controlcenter.kafka.AdminSupplier;
import io.confluent.controlcenter.rest.res.ConsumerGroupOffsets;
import io.confluent.controlcenter.rest.res.KafkaClusterDisplay;
import java.util.Map;
import org.apache.kafka.clients.admin.Admin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerOffsetsFetcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerOffsetsFetcher.class);
    private final ClusterMetadataDao clusterMetadataDao;
    private final AdminSupplier<String> adminClientSupplier;
    private final Map<String, Map<String, ConsumerGroupOffsets>> offsets;
    private final int consumerMetadataTimeout;

    @Inject
    public ConsumerOffsetsFetcher(ClusterMetadataDao clusterMetadataDao, AdminSupplier<String> adminClientSupplier, @ConsumerOffsetsModule.ConsumerOffsets Map<String, Map<String, ConsumerGroupOffsets>> offsets, @ConsumerOffsetsModule.ConsumerMetadataTimeout int consumerMetadataTimeout) {
        this.clusterMetadataDao = clusterMetadataDao;
        this.adminClientSupplier = adminClientSupplier;
        this.offsets = offsets;
        this.consumerMetadataTimeout = consumerMetadataTimeout;
    }

    @Override
    public void run() {
        try {
            for (KafkaClusterDisplay kafkaCluster : this.clusterMetadataDao.getKafkaClustersForManagement().clusters) {
                String clusterId = kafkaCluster.clusterId;
                try {
                    Admin adminClient = this.adminClientSupplier.getClient(clusterId);
                    Throwable throwable = null;
                    try {
                        ConsumerOffsetsDao cgDao = new ConsumerOffsetsDao(clusterId, adminClient, this.consumerMetadataTimeout);
                        Map<String, ConsumerGroupOffsets> cgOffsets = cgDao.getAllConsumerGroupOffsets();
                        this.offsets.put(clusterId, cgOffsets);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (adminClient == null) continue;
                        if (throwable != null) {
                            try {
                                adminClient.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        adminClient.close();
                    }
                }
                catch (Throwable t) {
                    log.warn(String.format("Unable to fetch consumer offsets for cluster id %s ", clusterId), t);
                }
            }
        }
        catch (Throwable t) {
            log.warn("unable to fetch consumer offsets", t);
        }
    }
}

