/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.NotSupportedException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaDao
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(KafkaDao.class);
    private static final long DEFAULT_METADATA_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    private final Admin kafkaAdminClient;
    private final String clusterId;
    private static final String TOPIC_NAME_CONFIG_LOOKUP = UUID.randomUUID().toString();

    public KafkaDao(String clusterId, Admin kafkaAdminClient) {
        this.clusterId = clusterId;
        this.kafkaAdminClient = kafkaAdminClient;
    }

    public List<TopicDescription> getTopics(Collection<String> topics, final boolean excludeDefaultTopics) throws InterruptedException, ExecutionException, TimeoutException {
        Collection topicMetadata = Collections2.filter(((Map)this.kafkaAdminClient.describeTopics(topics, new DescribeTopicsOptions().includeAuthorizedOperations(true)).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS)).values(), (Predicate)new Predicate<TopicDescription>(){

            public boolean apply(TopicDescription description) {
                return description != null && (!excludeDefaultTopics || !description.isInternal());
            }
        });
        return Ordering.natural().nullsFirst().onResultOf((Function)new Function<TopicDescription, String>(){

            public String apply(TopicDescription input) {
                return input.name();
            }
        }).immutableSortedCopy((Iterable)topicMetadata);
    }

    public List<TopicDescription> getTopics(boolean excludeDefaultTopics) throws InterruptedException, ExecutionException, TimeoutException {
        Collection topics = (Collection)this.kafkaAdminClient.listTopics(new ListTopicsOptions().listInternal(!excludeDefaultTopics)).names().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
        return this.getTopics(topics, excludeDefaultTopics);
    }

    public TopicDescription getTopic(String topic) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getTopics(Collections.singleton(topic), false).get(0);
    }

    public void createTopics(Collection<NewTopic> newTopics, boolean validate) throws InterruptedException, ExecutionException, TimeoutException {
        this.kafkaAdminClient.createTopics(newTopics, new CreateTopicsOptions().validateOnly(validate)).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public Config getTopicDefaultConfig(String topic, int defaultPartitions, short defaultReplicationFactor) throws InterruptedException, ExecutionException, TimeoutException {
        String lookUpTopicName = Strings.isNullOrEmpty((String)topic) ? TOPIC_NAME_CONFIG_LOOKUP : topic;
        try {
            return (Config)this.kafkaAdminClient.createTopics((Collection)ImmutableList.of((Object)new NewTopic(lookUpTopicName, Optional.empty(), Optional.empty())), new CreateTopicsOptions().validateOnly(true)).config(lookUpTopicName).get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            log.info("Failed to get topic defaults with empty partition and replication factor", (Throwable)ex);
            Throwable cause = ex.getCause();
            if (cause instanceof InvalidRequestException || cause instanceof UnsupportedVersionException) {
                return (Config)this.kafkaAdminClient.createTopics((Collection)ImmutableList.of((Object)new NewTopic(lookUpTopicName, defaultPartitions, defaultReplicationFactor)), new CreateTopicsOptions().validateOnly(true)).config(lookUpTopicName).get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            throw ex;
        }
    }

    public void deleteTopics(Collection<String> topics) throws InterruptedException, ExecutionException, TimeoutException {
        this.kafkaAdminClient.deleteTopics(topics).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public Map<ConfigResource, Config> getConfigs(Collection<ConfigResource> resources) throws InterruptedException, ExecutionException, TimeoutException {
        return (Map)this.kafkaAdminClient.describeConfigs(resources, new DescribeConfigsOptions().includeSynonyms(true)).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public void alterConfigs(Map<ConfigResource, Config> configs, boolean validateOnly) throws InterruptedException, ExecutionException, TimeoutException {
        this.kafkaAdminClient.alterConfigs(configs, new AlterConfigsOptions().validateOnly(validateOnly)).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public ImmutableMap<Integer, ImmutableList<ReplicaStatus>> getReplicas(String topic) throws InterruptedException, ExecutionException, TimeoutException {
        TopicDescription topicDescription = this.getTopic(topic);
        Set<TopicPartition> topicPartitions = topicDescription.partitions().stream().map(info -> new TopicPartition(topic, info.partition())).collect(Collectors.toSet());
        return this.getReplicas(topicPartitions);
    }

    public ImmutableList<ReplicaStatus> getReplicas(String topic, int partition) throws InterruptedException, ExecutionException, TimeoutException {
        return (ImmutableList)this.getReplicas((Set<TopicPartition>)ImmutableSet.of((Object)new TopicPartition(topic, partition))).get((Object)partition);
    }

    private ImmutableMap<Integer, ImmutableList<ReplicaStatus>> getReplicas(Set<TopicPartition> topicPartitions) throws InterruptedException, ExecutionException, TimeoutException {
        if (!(this.kafkaAdminClient instanceof ConfluentAdmin)) {
            throw new NotSupportedException("ReplicaStatus is not supported.");
        }
        ConfluentAdmin confluentAdmin = (ConfluentAdmin)this.kafkaAdminClient;
        ReplicaStatusResult replicaStatusResult = confluentAdmin.replicaStatus(topicPartitions, new ReplicaStatusOptions());
        ImmutableMap.Builder replicas = ImmutableMap.builder();
        for (TopicPartition topicPartition : topicPartitions) {
            replicas.put((Object)topicPartition.partition(), (Object)ImmutableList.copyOf((Collection)((Collection)((KafkaFuture)replicaStatusResult.result().get(topicPartition)).get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS))));
        }
        return replicas.build();
    }

    public Collection<AclBinding> getAcls(AclBindingFilter aclFilter) throws InterruptedException, ExecutionException, TimeoutException {
        return (Collection)this.kafkaAdminClient.describeAcls(aclFilter).values().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public void createAcls(Collection<AclBinding> aclBindings) throws InterruptedException, ExecutionException, TimeoutException {
        this.kafkaAdminClient.createAcls(aclBindings).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public void deleteAcls(Collection<AclBindingFilter> aclBindingFilters) throws InterruptedException, ExecutionException, TimeoutException {
        this.kafkaAdminClient.deleteAcls(aclBindingFilters).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public Collection<Node> getNodes() throws InterruptedException, ExecutionException, TimeoutException {
        return (Collection)this.kafkaAdminClient.describeCluster().nodes().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public Set<AclOperation> getAuthorizedOperations() throws InterruptedException, ExecutionException, TimeoutException {
        return (Set)this.kafkaAdminClient.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true)).authorizedOperations().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public Optional<Node> getController() throws InterruptedException, ExecutionException, TimeoutException {
        return Optional.ofNullable(this.kafkaAdminClient.describeCluster().controller().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS));
    }

    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public void close() {
        this.kafkaAdminClient.close();
    }
}

