/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.AbstractPermissionsService;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.KafkaMetadataDao;
import io.confluent.controlcenter.data.MetadataServiceClient;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.rest.res.AllPermissionsResponse;
import io.confluent.controlcenter.rest.res.KafkaCluster;
import io.confluent.controlcenter.util.ScopeUtils;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.InternalServerErrorException;
import org.apache.kafka.common.acl.AclOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbacPermissionsService
extends AbstractPermissionsService {
    private static final Logger log = LoggerFactory.getLogger(RbacPermissionsService.class);
    private static final String C3_BROKER_METRICS = "ControlCenterBrokerMetrics";
    protected static final Function<Scope, List<Action>> BROKER_METRICS = scope -> ImmutableList.of((Object)new Action(scope, new ResourceType(C3_BROKER_METRICS), C3_BROKER_METRICS, new Operation("Read")));
    private static final String C3_ALERTS = "ControlCenterAlerts";
    protected static final Function<Scope, List<Action>> ALERTS = scope -> ImmutableList.of((Object)new Action(scope, new ResourceType(C3_ALERTS), C3_ALERTS, new Operation("Write")));
    protected static final Function<Scope, List<Action>> LICENSE_MANAGEMENT = scope -> ImmutableList.of((Object)new Action(scope, new ResourceType("All"), "All", new Operation("All")));
    protected static final Map<PermissionsService.ControlCenterOperation, Function<Scope, List<Action>>> ALL_SCOPED_OPERATIONS = ImmutableMap.of((Object)((Object)PermissionsService.ControlCenterOperation.VIEW_BROKER_METRICS), BROKER_METRICS, (Object)((Object)PermissionsService.ControlCenterOperation.CLUSTER_ALERTS), ALERTS);
    private static final long MDS_CLUSTER_ID_EXPIRE_MS = 600000L;
    private static final long USER_CACHE_MAX_SIZE = 30L;
    private static final long USER_CACHE_EXPIRE_TIME_MS = 1000L;
    private final ClusterMetadataDao clusterMetadataDao;
    private final KafkaMetadataDao kafkaMetadataDao;
    private final MetadataServiceClient mdsClient;
    private final Supplier<String> mdsClusterIdSupplier;
    private final LoadingCache<JwtPrincipal, AllPermissionsResponse> principalOperationsCache;

    public RbacPermissionsService(ClusterMetadataDao clusterMetadata, KafkaMetadataDao kafkaMetadataDao, MetadataServiceClient mdsClient) {
        this(clusterMetadata, kafkaMetadataDao, mdsClient, (Supplier<String>)Suppliers.memoizeWithExpiration(mdsClient::getMetadataServiceKafkaId, (long)600000L, (TimeUnit)TimeUnit.MILLISECONDS), (CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize(30L).expireAfterWrite(1000L, TimeUnit.MILLISECONDS));
    }

    public RbacPermissionsService(ClusterMetadataDao clusterMetadata, KafkaMetadataDao kafkaMetadataDao, MetadataServiceClient mdsClient, Supplier<String> mdsClusterIdSupplier, CacheBuilder<Object, Object> principalOperationsCacheBuilder) {
        this.clusterMetadataDao = clusterMetadata;
        this.kafkaMetadataDao = kafkaMetadataDao;
        this.mdsClient = mdsClient;
        this.mdsClusterIdSupplier = mdsClusterIdSupplier;
        this.principalOperationsCache = principalOperationsCacheBuilder.build((CacheLoader)new CacheLoader<JwtPrincipal, AllPermissionsResponse>(){

            public AllPermissionsResponse load(@Nonnull JwtPrincipal principal) throws InterruptedException, ExecutionException, TimeoutException {
                return RbacPermissionsService.this.getAllOperationsInternal(principal);
            }
        });
    }

    @Override
    public AllPermissionsResponse getAllOperations(JwtPrincipal principal) {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0);
        try {
            return (AllPermissionsResponse)this.principalOperationsCache.get((Object)principal);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            log.error("Exception trying to fetch permissions for user {}. This will result in no access. Check that MDS is up and running.", (Object)principal.getName(), (Object)e.getCause());
            throw new InternalServerErrorException();
        }
    }

    @Override
    public <T> Set<T> getAllVisible(JwtPrincipal principal, Map<T, Scope> scopeMap) {
        return this.mdsClient.visibility(principal.getName(), principal.getJwt(), scopeMap);
    }

    @Override
    public <T> Set<T> authorizeAll(JwtPrincipal principal, Map<T, List<Action>> authorizeMap) {
        return this.mdsClient.authorize(principal.getName(), principal.getJwt(), authorizeMap);
    }

    private AllPermissionsResponse getAllOperationsInternal(JwtPrincipal principal) {
        String mdsClusterId = (String)this.mdsClusterIdSupplier.get();
        Set<KafkaCluster> visibleClusters = this.getAllVisible(principal, this.clusterMetadataDao.getKafkaClusters().stream().collect(Collectors.toMap(kc -> kc, kc -> ScopeUtils.buildKafkaScope(kc.clusterId))));
        HashMap<ClusterControlCenterOperation, List<Action>> authorizeMap = new HashMap<ClusterControlCenterOperation, List<Action>>();
        for (KafkaCluster cluster : visibleClusters) {
            for (Map.Entry<PermissionsService.ControlCenterOperation, Function<Scope, List<Action>>> e : ALL_SCOPED_OPERATIONS.entrySet()) {
                authorizeMap.put(new ClusterControlCenterOperation(cluster.clusterId, e.getKey()), e.getValue().apply(Scope.kafkaClusterScope((String)cluster.clusterId)));
            }
        }
        authorizeMap.put(new ClusterControlCenterOperation(mdsClusterId, PermissionsService.ControlCenterOperation.WRITE_LICENSE), LICENSE_MANAGEMENT.apply(ScopeUtils.buildKafkaScope(mdsClusterId)));
        Set allOperations = this.authorizeAll(principal, authorizeMap);
        HashMap<String, Set<PermissionsService.ControlCenterOperation>> clusterScopedOperations = new HashMap<String, Set<PermissionsService.ControlCenterOperation>>();
        HashSet<PermissionsService.ControlCenterOperation> globalOperations = new HashSet<PermissionsService.ControlCenterOperation>();
        for (ClusterControlCenterOperation clusterOperation : allOperations) {
            if (clusterOperation.operation.equals((Object)PermissionsService.ControlCenterOperation.WRITE_LICENSE) && clusterOperation.clusterId.equals(mdsClusterId)) {
                globalOperations.add(clusterOperation.operation);
                continue;
            }
            clusterScopedOperations.computeIfAbsent(clusterOperation.clusterId, unused -> new HashSet()).add(clusterOperation.operation);
        }
        for (KafkaCluster kafkaCluster : visibleClusters) {
            Set clusterOperations = clusterScopedOperations.computeIfAbsent(kafkaCluster.clusterId, unused -> new HashSet());
            try {
                Set<AclOperation> operations = this.kafkaMetadataDao.getAuthorizedOperations(TokenCredential.makeCredentialFromJwtOrNullPrincipal(kafkaCluster.clusterId, (Principal)principal));
                if (!operations.contains(AclOperation.ALTER_CONFIGS)) continue;
                clusterOperations.add(PermissionsService.ControlCenterOperation.VIEW_CLUSTER_SETTINGS);
            }
            catch (Exception e) {
                log.error("Could not get authorized operations for user {} from kafka-cluster {}. This may result in lowered access. Error type/message : \"{} : {}\"", new Object[]{principal.getName(), kafkaCluster.clusterId, e.getClass().getName(), e.getMessage()});
            }
        }
        return new AllPermissionsResponse(clusterScopedOperations, globalOperations);
    }

    static class ClusterControlCenterOperation {
        public final String clusterId;
        public final PermissionsService.ControlCenterOperation operation;

        public ClusterControlCenterOperation(String clusterId, PermissionsService.ControlCenterOperation operation) {
            this.clusterId = clusterId;
            this.operation = operation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterControlCenterOperation that = (ClusterControlCenterOperation)o;
            return Objects.equals(this.clusterId, that.clusterId) && this.operation == that.operation;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.clusterId, this.operation});
        }
    }
}

