/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.data.ServiceVisibilityFilter;
import io.confluent.controlcenter.httpclient.BearerTokenHttpCredential;
import io.confluent.controlcenter.httpclient.Client;
import io.confluent.controlcenter.rest.res.ConnectCluster;
import io.confluent.controlcenter.rest.res.KafkaCluster;
import io.confluent.controlcenter.rest.res.KsqlCluster;
import io.confluent.controlcenter.rest.res.KsqlServerInfo;
import io.confluent.controlcenter.rest.res.SchemaRegistryCluster;
import io.confluent.controlcenter.util.ScopeUtils;
import io.confluent.kafka.schemaregistry.security.permissions.entities.Permissions;
import io.confluent.security.authorizer.Scope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbacServiceVisibilityFilter
implements ServiceVisibilityFilter {
    private static final Logger log = LoggerFactory.getLogger(RbacServiceVisibilityFilter.class);
    private static final long SERVICE_TIMEOUT_SEC = 15L;
    private static int SERVICE_RETRIES_EACH = 2;
    private final ObjectMapper objectMapper;
    private final PermissionsService permissionsService;
    private SslContextFactory sslContextFactory;
    private Client client;

    public RbacServiceVisibilityFilter(ObjectMapper objectMapper, PermissionsService permissionsService) {
        this.objectMapper = objectMapper;
        this.permissionsService = permissionsService;
        this.sslContextFactory = null;
        this.client = null;
    }

    private synchronized void initClient() {
        if (this.client != null) {
            return;
        }
        this.client = new Client(this.sslContextFactory, this.objectMapper, 15L);
    }

    private Client getClient() {
        if (this.client == null) {
            this.initClient();
        }
        return this.client;
    }

    @Override
    public void setSslContextFactory(@NotNull SslContextFactory sslContextFactory) {
        if (this.client != null) {
            throw new IllegalStateException("trying to set SslContextFactory but Client is already built!");
        }
        Preconditions.checkNotNull((Object)sslContextFactory);
        this.sslContextFactory = sslContextFactory;
        this.initClient();
    }

    @Override
    public List<KafkaCluster> filterKafkaClusters(List<KafkaCluster> kafkaClusters, JwtPrincipal principal) {
        return this.getFilteredClusters(kafkaClusters, principal, cluster -> ScopeUtils.buildKafkaScope(cluster.clusterId));
    }

    @Override
    public List<KsqlCluster> filterKsqlClusters(List<KsqlCluster> ksqlClusters, JwtPrincipal principal) {
        return this.getFilteredClusters(ksqlClusters, principal, cluster -> this.getKsqlScope((KsqlCluster)cluster, principal.getJwt()));
    }

    @Override
    public List<ConnectCluster> filterConnectClusters(List<ConnectCluster> connectClusters, JwtPrincipal principal) {
        return this.getFilteredClusters(connectClusters, principal, cluster -> this.getConnectScope((ConnectCluster)cluster, principal.getJwt()));
    }

    @Override
    public List<SchemaRegistryCluster> filterSchemaRegistryClusters(List<SchemaRegistryCluster> srClusters, JwtPrincipal principal) {
        return this.getFilteredClusters(srClusters, principal, cluster -> this.getSchemaRegistryScope((SchemaRegistryCluster)cluster, principal.getJwt()));
    }

    Scope getKsqlScope(KsqlCluster ksqlCluster, String token) {
        try {
            KsqlServerInfo serverInfo = this.makeRequestWithRetries(baseUrl -> this.getClient().makeRequestNoBody(baseUrl + "/info", HttpMethod.GET, new BearerTokenHttpCredential(token), new TypeReference<KsqlServerInfo>(){}), ksqlCluster.getEndpoints(), "failed to connect to any KSQl nodes");
            Preconditions.checkNotNull((Object)serverInfo.getKafkaClusterId());
            Preconditions.checkNotNull((Object)serverInfo.getKsqlServiceId());
            return ScopeUtils.buildKsqlScope(serverInfo.getKafkaClusterId(), serverInfo.getKsqlServiceId());
        }
        catch (Exception e) {
            log.info("exception trying to request id from ksql-cluster({}): {}", (Object)ksqlCluster.getDisplayName(), (Object)e.getMessage());
            return null;
        }
    }

    Scope getConnectScope(ConnectCluster connectCluster, String token) {
        try {
            return this.makeRequestWithRetries(baseUrl -> this.getClient().makeRequestNoBody(baseUrl + "/permissions", HttpMethod.GET, new BearerTokenHttpCredential(token), new TypeReference<io.confluent.connect.security.permissions.entities.Permissions>(){}), connectCluster.urls, "failed to connect to any Connect nodes").getScope();
        }
        catch (Exception e) {
            log.info("exception trying to request id from connect-cluster({}): {}", (Object)connectCluster.displayName, (Object)e.getMessage());
            return null;
        }
    }

    Scope getSchemaRegistryScope(SchemaRegistryCluster schemaRegistryCluster, String token) {
        try {
            return this.makeRequestWithRetries(baseUrl -> this.getClient().makeRequestNoBody(baseUrl + "/permissions", HttpMethod.GET, new BearerTokenHttpCredential(token), new TypeReference<Permissions>(){}), schemaRegistryCluster.servers, "failed to connect to any SchemaRegistry nodes").getScope();
        }
        catch (Exception e) {
            log.info("exception trying to request id from schema-registry-cluster({}): {}", (Object)schemaRegistryCluster.displayName, (Object)e.getMessage());
            return null;
        }
    }

    protected <T> T makeRequestWithRetries(Function<String, T> makeRequest, List<String> urls, String errorMessage) {
        return Client.makeRequestWithRetries(makeRequest, urls, SERVICE_RETRIES_EACH, errorMessage);
    }

    private <T> List<T> getFilteredClusters(List<T> clusters, JwtPrincipal principal, Function<T, Scope> getScope) {
        Map<Object, Scope> scopeMap = clusters.stream().collect(HashMap::new, (m, v) -> {
            Scope cfr_ignored_0 = (Scope)m.put(v, getScope.apply(v));
        }, HashMap::putAll).entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (scopeMap.size() == 0) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.permissionsService.getAllVisible(principal, scopeMap));
    }
}

