/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.rest.res.AllPermissionsResponse;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScopedPermissions {
    private PermissionsService permissionsService;
    private JwtPrincipal principal;

    public ScopedPermissions() {
        this(null, null);
    }

    public ScopedPermissions(PermissionsService permissionsService, JwtPrincipal principal) {
        this.permissionsService = permissionsService;
        this.principal = principal;
    }

    public AllPermissionsResponse getAllOperations() {
        return this.permissionsService.getAllOperations(this.principal);
    }

    public Set<String> getAllVisibleClusters() {
        return this.permissionsService.getAllVisibleClusters(this.principal);
    }

    public Set<PermissionsService.ControlCenterOperation> getAllScopedOperations(String clusterId) {
        return this.permissionsService.getAllScopedOperations(this.principal, clusterId);
    }

    public Set<PermissionsService.ControlCenterOperation> getAllGlobalOperations() {
        return this.permissionsService.getAllGlobalOperations(this.principal);
    }

    public boolean hasClusterAlertsAccess(String clusterId) {
        return this.permissionsService.hasClusterAlertsAccess(this.principal, clusterId);
    }

    public Set<String> getAllClusterAlertsAccess() {
        return this.permissionsService.getAllClusterAlertsAccess(this.principal);
    }

    public boolean hasReadLicenseAccess() {
        return this.permissionsService.hasReadLicenseAccess(this.principal);
    }

    public boolean hasWriteLicenseAccess() {
        return this.permissionsService.hasWriteLicenseAccess(this.principal);
    }

    public boolean hasBrokerMetricsAccess(String clusterId) {
        return this.permissionsService.hasBrokerMetricsAccess(this.principal, clusterId);
    }

    public boolean isVisible(Scope scope) {
        return this.permissionsService.isVisible(this.principal, scope);
    }

    public <T> Set<T> getAllVisible(Map<T, Scope> scopeMap) {
        return this.permissionsService.getAllVisible(this.principal, scopeMap);
    }

    public boolean authorize(List<Action> actions) {
        return this.permissionsService.authorize(this.principal, actions);
    }

    public <T> Set<T> authorizeAll(Map<T, List<Action>> authorizeMap) {
        return this.permissionsService.authorizeAll(this.principal, authorizeMap);
    }
}

