/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.healthcheck;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.segment.analytics.Analytics;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.support.metrics.submitters.ConfluentSubmitter;
import io.confluent.support.metrics.submitters.ResponseHandler;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckModule.class);

    protected void configure() {
    }

    @Provides
    @ClusterStatus
    @Inject
    @Singleton
    protected Map<String, Map<CommandAlert.BrokerTriggerMetricType, Controlcenter.TriggerMeasurement>> provideClusterStatus() {
        return new ConcurrentHashMap<String, Map<CommandAlert.BrokerTriggerMetricType, Controlcenter.TriggerMeasurement>>();
    }

    @Provides
    @Inject
    public ConfluentSubmitter getConfluentSubmitter(@PhoneHomeCustomerId String customerId) {
        String componentId = "control-center";
        return new ConfluentSubmitter(customerId, "control-center", new ResponseHandler(){

            public void handle(HttpResponse httpResponse) {
                try {
                    log.info(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
                }
                catch (IOException e) {
                    log.error("can't parse response");
                }
            }
        });
    }

    @Provides
    @Inject
    @Singleton
    public Analytics getAnalytics(@SegmentId String segmentId) {
        return Analytics.builder((String)segmentId).build();
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SegmentId {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface PhoneHomeCustomerId {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface PhoneHomeEnabled {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ControlCenterInstance {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SessionId {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ClusterStatus {
    }
}

