/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.httpclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import io.confluent.controlcenter.httpclient.HttpCredential;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private static long DEFAULT_TIMEOUT_SEC = 15L;
    private final SslContextFactory sslContextFactory;
    private final HttpClient client;
    private final ObjectMapper objectMapper;
    private final long timeoutSec;

    public Client(ObjectMapper objectMapper) {
        this(null, objectMapper, DEFAULT_TIMEOUT_SEC);
    }

    public Client(SslContextFactory sslContextFactory, ObjectMapper objectMapper) {
        this(sslContextFactory, objectMapper, DEFAULT_TIMEOUT_SEC);
    }

    public Client(SslContextFactory sslContextFactory, ObjectMapper objectMapper, long timeoutSec) {
        Preconditions.checkNotNull((Object)objectMapper);
        this.sslContextFactory = sslContextFactory;
        this.objectMapper = objectMapper;
        this.timeoutSec = timeoutSec;
        this.client = this.sslContextFactory == null ? new HttpClient() : new HttpClient(this.sslContextFactory);
        try {
            this.client.start();
        }
        catch (Exception e) {
            log.error("exception starting HttpClient", (Throwable)e);
        }
    }

    public <O> O makeRequestNoBody(String url, HttpMethod httpMethod, HttpCredential credential, TypeReference<O> returnTypeRef) {
        return Client.makeRequestNoBody(this.client, this.objectMapper, this.timeoutSec, url, httpMethod, credential, returnTypeRef);
    }

    @VisibleForTesting
    static <O> O makeRequestNoBody(HttpClient httpClient, ObjectMapper objectMapper, long timeoutSec, String url, HttpMethod httpMethod, HttpCredential credential, TypeReference<O> returnTypeRef) {
        return Client.makeRequestNoBody(httpClient, objectMapper, timeoutSec, url, httpMethod, credential, returnTypeRef, (Set<Integer>)ImmutableSet.of((Object)200));
    }

    @VisibleForTesting
    static <O> O makeRequestNoBody(HttpClient httpClient, ObjectMapper objectMapper, long timeoutSec, String url, HttpMethod httpMethod, HttpCredential credential, TypeReference<O> returnTypeRef, Set<Integer> allowedStatusCodes) {
        try {
            InputStreamResponseListener listener = new InputStreamResponseListener();
            Client.prepareRequest(httpClient, url, httpMethod, credential).send((Response.CompleteListener)listener);
            return Client.parseResponse(objectMapper, timeoutSec, url, returnTypeRef, allowedStatusCodes, listener);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public <I, O> O makeRequestWithContent(String url, HttpMethod httpMethod, HttpCredential credential, MimeTypes.Type contentType, I content, TypeReference<O> returnTypeRef) {
        return Client.makeRequestWithContent(this.client, this.objectMapper, this.timeoutSec, url, httpMethod, credential, contentType, content, returnTypeRef, (Set<Integer>)ImmutableSet.of((Object)200));
    }

    public <I, O> O makeRequestWithContent(String url, HttpMethod httpMethod, HttpCredential credential, MimeTypes.Type contentType, I content, TypeReference<O> returnTypeRef, Set<Integer> allowedStatusCodes) {
        return Client.makeRequestWithContent(this.client, this.objectMapper, this.timeoutSec, url, httpMethod, credential, contentType, content, returnTypeRef, allowedStatusCodes);
    }

    @VisibleForTesting
    static <I, O> O makeRequestWithContent(HttpClient httpClient, ObjectMapper objectMapper, long timeoutSec, String url, HttpMethod httpMethod, HttpCredential credential, MimeTypes.Type contentType, I content, TypeReference<O> returnTypeRef, Set<Integer> allowedStatusCodes) {
        try {
            InputStreamResponseListener listener = new InputStreamResponseListener();
            Client.prepareRequest(httpClient, url, httpMethod, credential).content((ContentProvider)new StringContentProvider(contentType.toString(), Client.serializeObject(objectMapper, content), StandardCharsets.UTF_8)).send((Response.CompleteListener)listener);
            return Client.parseResponse(objectMapper, timeoutSec, url, returnTypeRef, allowedStatusCodes, listener);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static Request prepareRequest(HttpClient httpClient, String url, HttpMethod httpMethod, HttpCredential credential) {
        Request request = httpClient.newRequest(url).method(httpMethod);
        if (credential != null) {
            request = request.header(HttpHeader.AUTHORIZATION, credential.authorizationHeaderValue());
        }
        return request;
    }

    @VisibleForTesting
    static <O> O parseResponse(ObjectMapper objectMapper, long timeoutSec, String url, TypeReference<O> returnTypeRef, Set<Integer> allowedStatusCodes, InputStreamResponseListener listener) throws InterruptedException, TimeoutException, ExecutionException, IOException {
        Response response = listener.get(timeoutSec, TimeUnit.SECONDS);
        if (allowedStatusCodes.contains(response.getStatus())) {
            try (InputStream responseContent = listener.getInputStream();){
                O o = Client.deserializeObject(objectMapper, responseContent, returnTypeRef);
                return o;
            }
        }
        log.error("expected response code from {} to be one of {}, but was {}", new Object[]{url, allowedStatusCodes, response.getStatus()});
        throw new WebApplicationException("unexpected response code from " + url, Response.Status.BAD_GATEWAY);
    }

    @VisibleForTesting
    static <T> String serializeObject(ObjectMapper objectMapper, T object) throws IOException {
        if (object instanceof String) {
            return (String)object;
        }
        return objectMapper.writeValueAsString(object);
    }

    @VisibleForTesting
    static <T> T deserializeObject(ObjectMapper objectMapper, InputStream inputStream, TypeReference<T> typeRef) throws IOException {
        if (typeRef.getType().equals(String.class)) {
            return (T)CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        return (T)objectMapper.readValue(inputStream, typeRef);
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalServerErrorException();
        }
    }

    public static <T> T makeRequestWithRetries(Function<String, T> makeRequest, List<String> urls, int retriesEach, String errorMessage) {
        ArrayList<String> shuffledUrls = new ArrayList<String>(urls);
        Collections.shuffle(shuffledUrls);
        for (int r = 0; r < retriesEach; ++r) {
            for (String url : shuffledUrls) {
                try {
                    return makeRequest.apply(url);
                }
                catch (Exception e) {
                    log.warn("failed to make request to {}", (Object)url);
                }
            }
        }
        throw new WebApplicationException(errorMessage, Response.Status.BAD_GATEWAY);
    }
}

