/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.kafka.ConsumerSupplier;
import io.confluent.controlcenter.rest.TokenCredential;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class ConsumerManager<K, V>
implements ConsumerSupplier<K, V> {
    private final ClusterManager clusterManager;
    private final Map<String, Object> additionalConsumerConfigs;

    @Inject
    public ConsumerManager(ClusterManager clusterManager, Map<String, Object> additionalConsumerConfigs) {
        this.clusterManager = clusterManager;
        this.additionalConsumerConfigs = additionalConsumerConfigs;
    }

    @Override
    public Consumer<K, V> getConsumer(TokenCredential credential) {
        HashMap configs = Maps.newHashMap(this.clusterManager.getConfigs(credential));
        configs.putAll(this.additionalConsumerConfigs);
        ConsumerConfig consumerConfigs = new ConsumerConfig((Map)configs);
        return new KafkaConsumer(consumerConfigs.values());
    }
}

