/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import io.confluent.controlcenter.servicehealthcheck.SingleServiceHealthCheck;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KafkaRestManager {
    private static final Logger log = LoggerFactory.getLogger(KafkaRestManager.class);
    private final ExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setThreadFactory(Executors.defaultThreadFactory()).setNameFormat("kafka-rest-manager-%d").setDaemon(true).build());
    private final Function<List<String>, SingleServiceHealthCheck> serviceHealthCheckSupplier;
    private final Map<String, SingleServiceHealthCheck> healthCheckMap = new ConcurrentHashMap<String, SingleServiceHealthCheck>();

    @Inject
    public KafkaRestManager(@ServiceHealthCheckModule.KafkaRestServiceHealthCheck Function<List<String>, SingleServiceHealthCheck> serviceHealthCheckSupplier) {
        this.serviceHealthCheckSupplier = serviceHealthCheckSupplier;
    }

    public List<String> getEndpoints(String clusterId) {
        SingleServiceHealthCheck healthCheck = this.healthCheckMap.get(clusterId);
        if (healthCheck == null) {
            return null;
        }
        return healthCheck.getHealthyUrls();
    }

    public SingleServiceHealthCheck getHealthCheck(String clusterId) {
        return this.healthCheckMap.get(clusterId);
    }

    public void registerCluster(String clusterId, Map<String, Object> config) {
        this.putCluster(clusterId, config);
    }

    public void registerCluster(ListenableFuture<String> clusterIdFuture, final String clusterName, final Map<String, Object> config) {
        Futures.addCallback(clusterIdFuture, (FutureCallback)new FutureCallback<String>(){

            public void onSuccess(@Nullable String clusterId) {
                KafkaRestManager.this.putCluster(clusterId, config);
            }

            public void onFailure(Throwable t) {
                log.error("Failed to initialize kafka-rest for kafka cluster {}. Could not obtain kafka cluster id.", (Object)clusterName, (Object)t);
            }
        }, (Executor)this.executorService);
    }

    private void putCluster(String clusterId, Map<String, Object> config) {
        Preconditions.checkNotNull((Object)clusterId);
        List<String> urls = ConfigUtils.getList(config, "cprest.url");
        if (urls != null) {
            this.healthCheckMap.put(clusterId, this.serviceHealthCheckSupplier.apply(urls));
        }
    }
}

