/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.Iterables;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProducerResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractProducerResource.class);
    private String topic;
    private KafkaProducer<byte[], byte[]> producer;

    abstract KafkaProducer<byte[], byte[]> getProducer(String var1, Session var2);

    private static String extract(Map<String, List<String>> params, String key) {
        String out = "";
        if (params.containsKey(key)) {
            out = (String)Iterables.getLast((Iterable)params.get(key), (Object)"");
        }
        return StringUtils.stripToEmpty((String)out);
    }

    @OnMessage
    public void onMessage(String message) {
        log.trace("got message={}", (Object)message);
        if (this.producer == null) {
            return;
        }
        byte[] byteMessage = message.getBytes(StandardCharsets.UTF_8);
        ProducerRecord record = new ProducerRecord(this.topic, null, (Object)byteMessage);
        this.producer.send(record);
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="clusterId") String clusterId) {
        Map parameters = session.getRequestParameterMap();
        this.topic = AbstractProducerResource.extract(parameters, "topic");
        this.producer = this.getProducer(clusterId, session);
    }

    @OnClose
    public void onClose(CloseReason closeReason) {
        log.trace("closeReason={}", (Object)closeReason);
        if (this.producer != null) {
            try {
                log.trace("closing producer");
                this.producer.flush();
                this.producer.close();
            }
            catch (Throwable t) {
                log.warn("unable to close producer", t);
            }
        }
    }

    @OnError
    public void onError(Throwable throwable) {
        log.error("error", throwable);
        if (this.producer != null) {
            try {
                log.trace("closing producer");
                this.producer.flush();
                this.producer.close();
            }
            catch (Throwable t) {
                log.warn("unable to close producer", t);
            }
        }
    }
}

