/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.confluent.controlcenter.data.ConsumerOffsetsModule;
import io.confluent.controlcenter.data.ScopedKafkaMetadataDao;
import io.confluent.controlcenter.rest.VisibleCluster;
import io.confluent.controlcenter.rest.res.ConsumerGroup;
import io.confluent.controlcenter.rest.res.ConsumerGroupOffsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

@Path(value="/2.0/consumer/offsets/{clusterId}")
@Produces(value={"application/json"})
public class CachedConsumerOffsetsResource {
    private final Map<String, Map<String, ConsumerGroupOffsets>> offsets;
    @Context
    private ScopedKafkaMetadataDao scopedKafkaMetadataDao;

    @Inject
    public CachedConsumerOffsetsResource(@ConsumerOffsetsModule.ConsumerOffsets Map<String, Map<String, ConsumerGroupOffsets>> offsets) {
        this.offsets = offsets;
    }

    @GET
    public List<ConsumerGroup> all(@PathParam(value="clusterId") VisibleCluster cluster) throws InterruptedException, ExecutionException, TimeoutException {
        Map<String, ConsumerGroupOffsets> cgOffsets = this.filteredOffsets(cluster.getClusterId());
        return Lists.newArrayList((Iterable)cgOffsets.values().stream().map(ConsumerGroup::new).collect(Collectors.toList()));
    }

    @GET
    @Path(value="/{consumerGroupId}")
    public ConsumerGroupOffsets consumerGroup(@PathParam(value="clusterId") VisibleCluster cluster, @PathParam(value="consumerGroupId") String consumerGroupId) throws InterruptedException, ExecutionException, TimeoutException {
        Map<String, ConsumerGroupOffsets> cgOffsets = this.filteredOffsets(cluster.getClusterId());
        ConsumerGroupOffsets offsets = cgOffsets.get(consumerGroupId);
        if (offsets == null) {
            throw new NotFoundException("unable to find consumerGroupId=" + consumerGroupId);
        }
        return offsets;
    }

    private Map<String, ConsumerGroupOffsets> filteredOffsets(String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        Map<String, ConsumerGroupOffsets> cgOffsets = this.offsets.get(clusterId);
        if (cgOffsets == null) {
            throw new NotFoundException("unable to find clusterId=" + clusterId);
        }
        HashMap<String, ConsumerGroupOffsets> filteredOffsets = new HashMap<String, ConsumerGroupOffsets>();
        Set<String> filteredGroups = this.scopedKafkaMetadataDao.getConsumerGroups(clusterId);
        for (Map.Entry<String, ConsumerGroupOffsets> e : cgOffsets.entrySet()) {
            if (!filteredGroups.contains(e.getKey())) continue;
            filteredOffsets.put(e.getKey(), e.getValue());
        }
        return filteredOffsets;
    }
}

