/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.data.ConsumerOffsetsDao;
import io.confluent.controlcenter.data.ConsumerOffsetsDaoSupplier;
import io.confluent.controlcenter.data.ConsumerOffsetsModule;
import io.confluent.controlcenter.data.KafkaDao;
import io.confluent.controlcenter.data.KafkaDaoSupplier;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.kafka.AdminSupplier;
import io.confluent.controlcenter.rest.BrokerMetricsCluster;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.rest.VisibleCluster;
import io.confluent.controlcenter.util.PrincipalUtils;
import io.confluent.controlcenter.util.ScopeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.Principal;
import javax.inject.Provider;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public class ClusterConverter
implements ParamConverterProvider {
    private final AdminSupplier<TokenCredential> adminClientSupplier;
    private final PermissionsService permissionsService;
    private final int consumerMetadataTimeout;
    @Context
    Provider<SecurityContext> securityContext;

    @Inject
    public ClusterConverter(AdminSupplier<TokenCredential> adminClientSupplier, PermissionsService permissionsService, @ConsumerOffsetsModule.ConsumerMetadataTimeout int consumerMetadataTimeout) {
        this.adminClientSupplier = adminClientSupplier;
        this.permissionsService = permissionsService;
        this.consumerMetadataTimeout = consumerMetadataTimeout;
    }

    private void verifyKafkaClusterVisibility(String clusterId) {
        if (!this.permissionsService.isVisible(PrincipalUtils.jwtPrincipalOrNull((SecurityContext)this.securityContext.get()), ScopeUtils.buildKafkaScope(clusterId))) {
            throw new ForbiddenException("must have view access");
        }
    }

    private void verifyBrokerMetricsAccess(String clusterId) {
        if (!this.permissionsService.hasBrokerMetricsAccess(PrincipalUtils.jwtPrincipalOrNull((SecurityContext)this.securityContext.get()), clusterId)) {
            throw new ForbiddenException("must have broker metrics access");
        }
    }

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isAssignableFrom(KafkaDaoSupplier.class)) {
            return new ParamConverter<T>(){

                public T fromString(String clusterId) {
                    return (KafkaDaoSupplier)() -> {
                        try {
                            ClusterConverter.this.verifyKafkaClusterVisibility(clusterId);
                            return new KafkaDao(clusterId, ClusterConverter.this.adminClientSupplier.getClient(TokenCredential.makeCredentialFromJwtOrNullPrincipal(clusterId, (Principal)PrincipalUtils.jwtPrincipalOrNull((SecurityContext)ClusterConverter.this.securityContext.get()))));
                        }
                        catch (IllegalArgumentException iae) {
                            throw new NotFoundException("unable to locate cluster " + clusterId);
                        }
                    };
                }

                public String toString(T kafkaDaoSupplier) {
                    return ((KafkaDao)((KafkaDaoSupplier)kafkaDaoSupplier).get()).clusterId();
                }
            };
        }
        if (rawType.isAssignableFrom(ConsumerOffsetsDaoSupplier.class)) {
            return new ParamConverter<T>(){

                public T fromString(String clusterId) {
                    return (ConsumerOffsetsDaoSupplier)() -> {
                        try {
                            ClusterConverter.this.verifyKafkaClusterVisibility(clusterId);
                            TokenCredential credential = TokenCredential.makeCredentialFromJwtOrNullPrincipal(clusterId, (Principal)PrincipalUtils.jwtPrincipalOrNull((SecurityContext)ClusterConverter.this.securityContext.get()));
                            return new ConsumerOffsetsDao(clusterId, ClusterConverter.this.adminClientSupplier.getClient(credential), ClusterConverter.this.consumerMetadataTimeout);
                        }
                        catch (IllegalArgumentException iae) {
                            throw new NotFoundException("unable to locate cluster " + clusterId);
                        }
                    };
                }

                public String toString(T consumerOffsetsDaoSupplier) {
                    return ((ConsumerOffsetsDao)((ConsumerOffsetsDaoSupplier)consumerOffsetsDaoSupplier).get()).clusterId();
                }
            };
        }
        if (rawType.isAssignableFrom(BrokerMetricsCluster.class)) {
            return new ParamConverter<T>(){

                public T fromString(String clusterId) {
                    ClusterConverter.this.verifyBrokerMetricsAccess(clusterId);
                    return new BrokerMetricsCluster(clusterId);
                }

                public String toString(T brokerMetricsCluster) {
                    return ((BrokerMetricsCluster)brokerMetricsCluster).getClusterId();
                }
            };
        }
        if (rawType.isAssignableFrom(VisibleCluster.class)) {
            return new ParamConverter<T>(){

                public T fromString(String clusterId) {
                    ClusterConverter.this.verifyKafkaClusterVisibility(clusterId);
                    return new VisibleCluster(clusterId);
                }

                public String toString(T visibleCluster) {
                    return ((VisibleCluster)visibleCluster).getClusterId();
                }
            };
        }
        return null;
    }
}

