/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import io.confluent.common.security.auth.ApiKeyPrincipal;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.rest.AdminVisitor;
import io.confluent.controlcenter.rest.ApiKeyCredential;
import io.confluent.controlcenter.rest.ClusterMatched;
import io.confluent.controlcenter.rest.TokenCredential;
import java.security.Principal;
import org.apache.kafka.clients.admin.Admin;

public abstract class ClusterCredential
implements ClusterMatched {
    public final String cluster;

    protected ClusterCredential(String cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean matchesCluster(String clusterId) {
        return this.cluster.equals(clusterId);
    }

    public static ClusterCredential makeCredentialFromJwtPrincipalOrApiKeyPrincipal(String clusterId, Principal principal) {
        if (principal == null) {
            throw new IllegalArgumentException("invalid principal");
        }
        ClusterCredential cred = null;
        if (principal instanceof JwtPrincipal) {
            cred = TokenCredential.makeCredentialFromJwtPrincipal(clusterId, principal);
        } else if (principal instanceof ApiKeyPrincipal) {
            cred = ApiKeyCredential.makeCredentialFromApiKeyPrincipal(clusterId, (ApiKeyPrincipal)principal);
        } else {
            throw new IllegalArgumentException(String.format("invalid principal of unsupported type - %s", principal.getClass().getName()));
        }
        return cred;
    }

    public abstract Admin accept(AdminVisitor var1);
}

