/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import io.confluent.command.CommandStore;
import io.confluent.command.record.Command;
import io.confluent.controlcenter.data.ScopedPermissions;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;

@Path(value="/2.0/command")
@Produces(value={"application/json"})
public class CommandResource {
    private final CommandStore commandStore;
    @Context
    private ScopedPermissions scopedPermissions;

    @Inject
    public CommandResource(CommandStore commandStore) {
        this.commandStore = commandStore;
    }

    @GET
    @Path(value="/{commandConfigType}")
    public Collection<KeyValue<Command.CommandKey, Command.CommandMessage>> getAll(@PathParam(value="commandConfigType") Command.CommandConfigType commandConfigType) {
        try (KeyValueIterator all = this.commandStore.getStore().all();){
            ImmutableList immutableList = ImmutableList.copyOf((Iterator)Iterators.filter((Iterator)all, entry -> {
                if (entry == null) {
                    return false;
                }
                Command.CommandConfigType configType = ((Command.CommandKey)entry.key).getConfigType();
                return this.canAccessCommand(configType, (Command.CommandMessage)entry.value);
            }));
            return immutableList;
        }
    }

    @GET
    @Path(value="/{commandConfigType}/{guid}")
    public Command.CommandMessage get(@PathParam(value="commandConfigType") Command.CommandConfigType commandConfigType, @PathParam(value="guid") String guid) {
        Command.CommandMessage message = (Command.CommandMessage)this.commandStore.getStore().get((Object)Command.CommandKey.newBuilder().setConfigType(commandConfigType).setGuid(guid).build());
        if (message == null) {
            throw new NotFoundException("guid=" + guid + " with type=" + commandConfigType + " does not exist");
        }
        this.verifyCommandAccess(commandConfigType, message);
        return message;
    }

    @PUT
    @Path(value="/{commandConfigType}/{guid}")
    public Response post(@PathParam(value="commandConfigType") Command.CommandConfigType commandConfigType, @PathParam(value="guid") String guid, Command.CommandMessage message) throws InterruptedException, ExecutionException, TimeoutException {
        this.verifyCommandAccess(commandConfigType, message);
        this.commandStore.awaitCommand(Command.CommandKey.newBuilder().setConfigType(commandConfigType).setGuid(guid).build(), message);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{commandConfigType}/{guid}")
    public Response delete(@PathParam(value="commandConfigType") Command.CommandConfigType commandConfigType, @PathParam(value="guid") String guid) throws InterruptedException, ExecutionException, TimeoutException {
        this.get(commandConfigType, guid);
        this.commandStore.awaitCommand(Command.CommandKey.newBuilder().setConfigType(commandConfigType).setGuid(guid).build(), null);
        return Response.noContent().build();
    }

    private boolean canAccessCommand(Command.CommandConfigType commandConfigType, Command.CommandMessage message) {
        try {
            this.verifyCommandAccess(commandConfigType, message);
            return true;
        }
        catch (ForbiddenException e) {
            return false;
        }
    }

    private void verifyCommandAccess(Command.CommandConfigType commandConfigType, Command.CommandMessage message) {
        if (!this.scopedPermissions.hasWriteLicenseAccess()) {
            throw new ForbiddenException("license write access required");
        }
    }
}

