/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.MoreObjects;
import io.confluent.common.security.auth.JwtPrincipal;
import java.security.Principal;
import java.util.Objects;

public class CompoundClusterTokenCredential {
    public final String kafkaClusterId;
    public final String secondaryClusterId;
    public final String token;
    public final String subject;

    private CompoundClusterTokenCredential(String kafkaClusterId, String secondaryClusterId, String token, String subject) {
        this.kafkaClusterId = kafkaClusterId;
        this.secondaryClusterId = secondaryClusterId;
        this.token = token;
        this.subject = subject;
    }

    public static CompoundClusterTokenCredential makeCredential(String kafkaClusterId, String secondaryClusterId) {
        return new CompoundClusterTokenCredential(kafkaClusterId, secondaryClusterId, null, null);
    }

    public static CompoundClusterTokenCredential makeCredentialFromJwtOrNullPrincipal(String kafkaClusterId, String secondaryClusterId, Principal principal) {
        if (!(principal instanceof JwtPrincipal)) {
            return CompoundClusterTokenCredential.makeCredential(kafkaClusterId, secondaryClusterId);
        }
        JwtPrincipal p = (JwtPrincipal)principal;
        return new CompoundClusterTokenCredential(kafkaClusterId, secondaryClusterId, p.getJwt(), p.getName());
    }

    public static CompoundClusterTokenCredential makeCredentialFromJwtPrincipal(String kafkaClusterId, String secondaryClusterId, JwtPrincipal principal) {
        if (principal == null) {
            throw new IllegalArgumentException("invalid token");
        }
        return new CompoundClusterTokenCredential(kafkaClusterId, secondaryClusterId, principal.getJwt(), principal.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundClusterTokenCredential that = (CompoundClusterTokenCredential)o;
        return Objects.equals(this.kafkaClusterId, that.kafkaClusterId) && Objects.equals(this.secondaryClusterId, that.secondaryClusterId) && Objects.equals(this.token, that.token) && Objects.equals(this.subject, that.subject);
    }

    public int hashCode() {
        return Objects.hash(this.kafkaClusterId, this.secondaryClusterId, this.token, this.subject);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("kafkaClusterId", (Object)this.kafkaClusterId).add("secondaryClusterId", (Object)this.secondaryClusterId).add("token", (Object)this.token).add("subject", (Object)this.subject).toString();
    }
}

