/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.rest.AbstractClusterLookupProxyServlet;
import io.confluent.controlcenter.rest.ProxyServlet;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import java.util.List;
import java.util.Random;

public class ConnectProxyServlet
extends AbstractClusterLookupProxyServlet {
    private final Random random = new Random();
    private final ServiceHealthCheck connectHealthCheck;

    @Inject
    public ConnectProxyServlet(@ServiceHealthCheckModule.ConnectHealthCheck ServiceHealthCheck connectHealthCheck) {
        this.connectHealthCheck = connectHealthCheck;
    }

    @Override
    public String lookupEndpoint(String connectClusterName) {
        List<String> urls = this.connectHealthCheck.getHealthyUrls(connectClusterName);
        if (urls == null) {
            return null;
        }
        if (urls.isEmpty()) {
            throw new RuntimeException("all nodes in Connect cluster '" + connectClusterName + "' are down");
        }
        return ProxyServlet.normalizeUrlProtocol(urls.get(this.random.nextInt(urls.size())));
    }
}

