/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.data.ScopedPermissions;
import io.confluent.controlcenter.healthcheck.HealthCheck;
import io.confluent.controlcenter.util.ScopeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

@Path(value="/2.0/health")
@Produces(value={"application/json"})
public class HealthCheckResource {
    private final HealthCheck healthCheck;
    @Context
    private ScopedPermissions scopedPermissions;

    @Inject
    public HealthCheckResource(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    @GET
    @Path(value="/status")
    public Map<String, Object> status() {
        HashMap<String, Object> statusMap = new HashMap<String, Object>();
        statusMap.put("bootstrapClusterId", this.healthCheck.getBootstrapClusterId());
        statusMap.put("clusterStatus", this.filteredKafkaClusterMap(this.healthCheck.getAllClusterStatus()));
        return statusMap;
    }

    private <T> Map<String, T> filteredKafkaClusterMap(Map<String, T> clusterMap) {
        HashMap scopeMap = new HashMap();
        clusterMap.entrySet().forEach(e -> scopeMap.put(e, ScopeUtils.buildKafkaScope((String)e.getKey())));
        return this.scopedPermissions.getAllVisible(scopeMap).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

